/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.EntityConstantExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class InExpression
extends AbstractExpression<Boolean> {
    private final AbstractExpression<?> inner;
    private final ArrayList<AbstractExpression<?>> values = Lists.newArrayList();
    private String alias;

    public InExpression(AbstractExpression<?> inner, Expression<?>[] values) {
        super(Boolean.class);
        this.inner = inner;
        for (Expression<?> expression : values) {
            this.values.add((AbstractExpression)expression);
        }
    }

    public InExpression(Expression<?> inner, Collection<?> values) {
        super(Boolean.class);
        this.inner = (AbstractExpression)inner;
        for (Object value : values) {
            if (value instanceof AbstractExpression) {
                this.values.add((AbstractExpression)value);
                continue;
            }
            this.values.add(new EntityConstantExpression(null, value));
        }
    }

    public void add(AbstractExpression<?> expression) {
        this.values.add(expression);
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        String values = Joiner.on((String)", ").join((Iterable)Lists.transform(this.values, (Function)new Function<AbstractExpression<?>, String>(){

            public String apply(AbstractExpression<?> input) {
                return input.generateJpqlRestriction(query);
            }
        }));
        return this.inner.generateJpqlRestriction(query) + " in (" + values + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(final BaseQueryImpl<?> query) {
        String inner = this.inner.getSqlRestrictionFragments(query)[0];
        String values = Joiner.on((String)", ").join((Iterable)Lists.transform(this.values, (Function)new Function<AbstractExpression<?>, String>(){

            public String apply(AbstractExpression<?> input) {
                return input.getSqlRestrictionFragments(query)[0];
            }
        }));
        return new String[]{inner + " IN (" + values + ")"};
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (Boolean)row.getObject(this.alias);
    }
}

