/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public class SimpleConstantExpression<T>
extends AbstractExpression<T> {
    private final T value;

    public SimpleConstantExpression(TypeImpl<T> type, T value) {
        super(type != null ? type.getJavaType() : value.getClass());
        this.value = value;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        if (Number.class.isAssignableFrom(this.getJavaType())) {
            return this.value.toString();
        }
        return "'" + this.value.toString() + "'";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        if (Number.class.isAssignableFrom(this.getJavaType())) {
            return new String[]{this.value.toString()};
        }
        return new String[]{"'" + this.value.toString() + "'"};
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return this.value;
    }
}

