/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.join;

import java.util.List;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;

public class FetchImpl<Z, X>
extends FetchParentImpl<Z, X>
implements Fetch<Z, X> {
    private final FetchParentImpl<?, Z> parent;
    private final JoinedMapping<? super Z, ?, X> mapping;
    private final JoinType joinType;

    public FetchImpl(FetchParentImpl<?, Z> parent, JoinedMapping<? super Z, ?, X> mapping, JoinType joinType) {
        super(mapping);
        this.parent = parent;
        this.mapping = mapping;
        this.joinType = joinType;
    }

    @Override
    public String generateJpqlFetches(String parent) {
        StringBuilder builder = new StringBuilder();
        builder.append("left join fetch ");
        builder.append(parent).append(".").append(this.mapping.getAttribute().getName());
        String children = super.generateJpqlFetches(parent + "." + this.mapping.getAttribute().getName());
        if (StringUtils.isNotBlank((String)children)) {
            builder.append("\n").append(children);
        }
        return builder.toString();
    }

    @Override
    public void generateSqlJoins(AbstractCriteriaQueryImpl<?> query, List<String> selfJoins) {
        String parentAlias = this.getParent().getPrimaryTableAlias(query);
        String alias = this.getPrimaryTableAlias(query);
        selfJoins.add(this.mapping.join(parentAlias, alias, this.joinType));
        super.generateSqlJoins(query, selfJoins);
    }

    public AttributeImpl<? super Z, ?> getAttribute() {
        return this.mapping.getAttribute();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public JoinedMapping<? super Z, ?, X> getMapping() {
        return this.mapping;
    }

    public FetchParentImpl<?, Z> getParent() {
        return this.parent;
    }

    @Override
    public String getPrimaryTableAlias(BaseQueryImpl<?> query) {
        if (this.mapping.getMappingType() == JoinedMapping.MappingType.EMBEDDABLE) {
            return this.parent.getPrimaryTableAlias(query);
        }
        return super.getPrimaryTableAlias(query);
    }
}

