/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractTypeExpression;
import org.batoo.jpa.core.impl.criteria.expression.EntityTypeExpression;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.criteria.join.FetchImpl;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class EntityPath<Z, X>
extends ParentPath<Z, X>
implements Joinable {
    private final SingularAssociationMapping<?, Z> mapping;
    private final String pathName;
    private final EntityTypeImpl<X> entity;
    private FetchImpl<Z, X> fetchRoot;

    public EntityPath(ParentPath<?, Z> parent, SingularAssociationMapping<?, Z> mapping, EntityTypeImpl<X> entity) {
        super(parent, entity.getJavaType());
        this.mapping = mapping;
        this.pathName = mapping.getAttribute().getName();
        this.entity = entity;
        if (!this.mapping.isOwner() || this.mapping.getForeignKey() == null) {
            this.fetchRoot = this.getParentPath().getFetchRoot().join(this.pathName, JoinType.LEFT);
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlRestriction(query));
        builder.append(".").append(this.pathName);
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        StringBuilder builder = new StringBuilder();
        if (this.getParentPath() instanceof AbstractFrom && StringUtils.isNotBlank((String)this.getParentPath().getAlias())) {
            builder.append(this.getParentPath().getAlias());
        } else {
            builder.append(this.getParentPath().generateJpqlSelect(null, false));
        }
        builder.append(".").append(this.pathName);
        if (selected && StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.getFetchRoot().generateSqlSelect(query, selected, false);
    }

    @Override
    public String getColumnAlias(BaseQueryImpl<?> query, AbstractColumn column) {
        for (JoinColumn joinColumn : this.mapping.getForeignKey().getJoinColumns()) {
            if (joinColumn.getReferencedColumn() != column) continue;
            String columnAlias = this.getParentPath().getColumnAlias(query, joinColumn);
            if (columnAlias != null) {
                return columnAlias;
            }
            return this.getParentPath().getRootPath().getTableAlias(query, joinColumn.getTable()) + "." + joinColumn.getName();
        }
        return null;
    }

    @Override
    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    @Override
    public FetchParentImpl<?, X> getFetchRoot() {
        if (this.fetchRoot == null) {
            this.fetchRoot = this.getParentPath().getFetchRoot().join(this.pathName, JoinType.LEFT);
        }
        return this.fetchRoot;
    }

    @Override
    protected <C, Y> Mapping<? super X, C, Y> getMapping(String name) {
        Mapping mapping = this.entity.getRootMapping().getChild(name);
        if (mapping == null) {
            throw this.cannotDereference(name);
        }
        return mapping;
    }

    public EntityTypeImpl<X> getModel() {
        return this.entity;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        if (!this.mapping.isOwner() || this.mapping.getForeignKey() == null) {
            return this.getFetchRoot().getSqlRestrictionFragments(query, MapJoinImpl.MapSelectType.VALUE);
        }
        ArrayList restrictions = Lists.newArrayList();
        ForeignKey foreignKey = this.mapping.getForeignKey();
        String tableAlias = this.getParentPath().getFetchRoot().getTableAlias(query, foreignKey.getTable());
        for (AbstractColumn abstractColumn : foreignKey.getJoinColumns()) {
            restrictions.add(tableAlias + "." + abstractColumn.getName());
        }
        return restrictions.toArray(new String[restrictions.size()]);
    }

    @Override
    public String getTableAlias(BaseQueryImpl<?> query, AbstractTable table) {
        return this.getFetchRoot().getTableAlias(query, table);
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return this.fetchRoot.handle(session, row);
    }

    public AbstractTypeExpression<X> type() {
        if (this.entity.getRootType().getInheritanceType() != null) {
            return new EntityTypeExpression(this, this.entity.getRootType().getDiscriminatorColumn());
        }
        return new StaticTypeExpression<X>(this, this.getModel().getBindableJavaType());
    }
}

