/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.instance;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.persistence.PersistenceException;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public final class Prioritizer {
    public static void sort(ArrayList<ManagedInstance<?>> updates, ArrayList<ManagedInstance<?>> removals, ManagedInstance<?>[] sortedUpdates, ManagedInstance<?>[] sortedRemovals, CallbackAvailability callbackAvailability) {
        Prioritizer.sort(updates, sortedUpdates, true, callbackAvailability);
        Prioritizer.sort(removals, sortedRemovals, false, callbackAvailability);
    }

    private static void sort(ArrayList<ManagedInstance<?>> updates, ManagedInstance<?>[] sortedUpdates, boolean forUpdates, CallbackAvailability callbackAvailability) {
        boolean hasDependency;
        Iterator<Object> i;
        boolean removed;
        int instanceNo = 0;
        HashSet entities = Sets.newHashSet();
        for (int i2 = 0; i2 < updates.size(); ++i2) {
            entities.add(updates.get(i2).getType());
        }
        for (EntityTypeImpl entity : entities) {
            entity.updateAvailability(callbackAvailability, forUpdates);
        }
        do {
            removed = false;
            i = entities.iterator();
            while (i.hasNext()) {
                hasDependency = false;
                EntityTypeImpl e1 = (EntityTypeImpl)i.next();
                for (EntityTypeImpl e2 : entities) {
                    EntityTypeImpl dependency;
                    EntityTypeImpl dependent = forUpdates ? e1 : e2;
                    if (dependent.getDependenciesFor(dependency = forUpdates ? e2 : e1).length == 0) continue;
                    hasDependency = true;
                    break;
                }
                if (hasDependency) continue;
                i.remove();
                Iterator<ManagedInstance<?>> i2 = updates.iterator();
                while (i2.hasNext()) {
                    ManagedInstance<?> instance = i2.next();
                    if (instance.getType() != e1) continue;
                    i2.remove();
                    sortedUpdates[instanceNo++] = instance;
                }
                removed = true;
            }
        } while (removed);
        while (updates.size() > 0) {
            boolean found = false;
            i = updates.iterator();
            while (i.hasNext()) {
                hasDependency = false;
                ManagedInstance mi1 = (ManagedInstance)i.next();
                EntityTypeImpl e1 = mi1.getType();
                Object i1 = mi1.getInstance();
                block8: for (int j = 0; j < updates.size(); ++j) {
                    ManagedInstance<?> mi2 = updates.get(j);
                    if (mi1 == mi2) continue;
                    EntityTypeImpl<?> e2 = mi2.getType();
                    Object i2 = mi2.getInstance();
                    for (AssociationMapping<?, ?, ?> association : e1.getDependenciesFor(e2)) {
                        Object dependency;
                        Object dependent = forUpdates ? i1 : i2;
                        Object object = dependency = forUpdates ? i2 : i1;
                        if (!association.references(dependent, dependency)) continue;
                        hasDependency = true;
                        break block8;
                    }
                }
                if (hasDependency) continue;
                sortedUpdates[instanceNo++] = mi1;
                i.remove();
                found = true;
            }
            if (found) continue;
            throw new PersistenceException("Circular dependencies not yet supported");
        }
    }

    private Prioritizer() {
    }
}

