/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.UniqueConstraintMetadata;

public abstract class AbstractTable {
    private final AbstractLocator locator;
    private final String catalog;
    private final String schema;
    private String name;
    private final Map<String, AbstractColumn> columnMap = Maps.newHashMap();
    private final Map<String, String[]> uniqueConstraints = Maps.newHashMap();
    private final List<ForeignKey> foreignKeys = Lists.newArrayList();
    private final HashMap<String, String> insertSqlMap = Maps.newHashMap();
    private final HashMap<EntityTypeImpl<?>, String> updateSqlMap = Maps.newHashMap();
    private String updateSql;
    private FinalWrapper<String> versionUpdateSql;
    private FinalWrapper<String> versionSelectSql;
    private FinalWrapper<AbstractColumn[]> columns;
    private AbstractColumn[] updateColumns;
    private AbstractColumn[] versionUpdateColumns;
    private AbstractColumn[] selectVersionColumns;
    private final Map<String, AbstractColumn[]> insertColumnsMap = Maps.newHashMap();
    private final Map<EntityTypeImpl<?>, AbstractColumn[]> updateColumnsMap = Maps.newHashMap();

    public AbstractTable(String defaultName, TableMetadata metadata) {
        this(metadata);
        if (this.name == null) {
            this.name = defaultName;
        }
    }

    public AbstractTable(TableMetadata metadata) {
        this.locator = metadata != null ? metadata.getLocator() : null;
        this.catalog = metadata != null && StringUtils.isNotBlank((String)metadata.getCatalog()) ? metadata.getCatalog() : null;
        String string = this.schema = metadata != null && StringUtils.isNotBlank((String)metadata.getSchema()) ? metadata.getSchema() : null;
        if (metadata != null) {
            if (StringUtils.isNotBlank((String)metadata.getName())) {
                this.name = metadata.getName();
            }
            for (UniqueConstraintMetadata constraint : metadata.getUniqueConstraints()) {
                this.uniqueConstraints.put(constraint.getName(), constraint.getColumnNames());
            }
        }
    }

    public void addColumn(AbstractColumn column) {
        AbstractColumn existing = this.columnMap.get(column.getName());
        if (existing != null) {
            if (column instanceof JoinColumn) {
                JoinColumn joinColumn = (JoinColumn)column;
                if (!joinColumn.isInsertable() && !joinColumn.isUpdatable()) {
                    joinColumn.setVirtual(existing);
                }
                return;
            }
            throw new MappingException("Duplicate column names " + column.getName() + " on table " + this.name, column.getLocator(), existing.getLocator());
        }
        this.columnMap.put(column.getName(), column);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    private synchronized void generateInsertSql(final EntityTypeImpl<?> type, int size) {
        ArrayList insertColumns;
        String sqlKey = type != null ? type.getName() + size : "" + size;
        String sql = this.insertSqlMap.get(sqlKey);
        if (sql != null) {
            return;
        }
        Collection filteredColumns = type == null ? this.columnMap.values() : Collections2.filter(this.columnMap.values(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                return AbstractTable.this.isInsertableColumn(type, input);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>((List)(insertColumns = Lists.newArrayList())){
            final /* synthetic */ List val$insertColumns;
            {
                this.val$insertColumns = list;
            }

            public String apply(AbstractColumn input) {
                this.val$insertColumns.add(input);
                return input.getName();
            }
        });
        if (columnNames.size() == 0) {
            sql = "INSERT INTO " + this.getQName() + " DEFAULT VALUES";
        } else {
            Collection singleParams = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

                public String apply(AbstractColumn input) {
                    String writeParam = null;
                    if (input instanceof BasicColumn) {
                        ColumnTransformerMetadata columnTransformer = ((BasicAttribute)((BasicMapping)((BasicColumn)input).getMapping()).getAttribute()).getColumnTransformer();
                        writeParam = columnTransformer != null ? columnTransformer.getWrite() : null;
                    }
                    writeParam = Strings.isNullOrEmpty(writeParam) ? "?" : writeParam;
                    return writeParam;
                }
            });
            String singleParamStr = "\t(" + Joiner.on((String)", ").join((Iterable)singleParams) + ")";
            String parametersStr = StringUtils.repeat((String)singleParamStr, (String)",\n", (int)size);
            String columnNamesStr = Joiner.on((String)", ").join((Iterable)columnNames);
            sql = "INSERT INTO " + this.getQName() + "\n(" + columnNamesStr + ")" + "\nVALUES\n" + parametersStr;
        }
        this.insertSqlMap.put(sqlKey, sql);
        this.insertColumnsMap.put(sqlKey, insertColumns.toArray(new AbstractColumn[insertColumns.size()]));
    }

    private synchronized void generateUpdateSql(final EntityTypeImpl<?> type, Map<String, AbstractColumn> pkColumns) {
        String sql = this.updateSqlMap.get(type);
        if (sql != null) {
            return;
        }
        final ArrayList updateColumns = Lists.newArrayList();
        Collection filteredColumns = type == null ? this.columnMap.values() : Collections2.filter(this.columnMap.values(), (Predicate)new Predicate<AbstractColumn>(){

            public boolean apply(AbstractColumn input) {
                return AbstractTable.this.isUpdatableColumn(type, input);
            }
        });
        Collection columnNames = Collections2.transform((Collection)filteredColumns, (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                if (!input.isPrimaryKey()) {
                    updateColumns.add(input);
                    return input.getName() + " = ?";
                }
                return null;
            }
        });
        Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                updateColumns.add(input);
                return input.getName() + " = ?";
            }
        });
        String columnNamesStr = Joiner.on((String)", ").skipNulls().join((Iterable)columnNames);
        String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
        sql = "UPDATE " + this.getQName() + " SET" + "\n" + columnNamesStr + "\nWHERE " + restrictionStr;
        if (type != null) {
            this.updateSqlMap.put(type, sql);
            this.updateColumnsMap.put(type, updateColumns.toArray(new AbstractColumn[updateColumns.size()]));
        } else {
            this.updateSql = sql;
            this.updateColumns = updateColumns.toArray(new AbstractColumn[updateColumns.size()]);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    protected Map<String, AbstractColumn> getColumnMap() {
        return this.columnMap;
    }

    public Collection<String> getColumnNames() {
        return Collections2.transform(this.columnMap.values(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                return input.getName();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractColumn[] getColumns() {
        FinalWrapper<AbstractColumn[]> wrapper = this.columns;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.columns == null) {
                    this.columns = new FinalWrapper<AbstractColumn[]>(this.columnMap.values().toArray(new AbstractColumn[this.columnMap.values().size()]));
                }
                wrapper = this.columns;
            }
        }
        return (AbstractColumn[])wrapper.value;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    protected AbstractColumn[] getInsertColumns(EntityTypeImpl<?> entity, int size) {
        return this.insertColumnsMap.get(entity != null ? entity.getName() + size : "" + size);
    }

    protected String getInsertSql(EntityTypeImpl<?> entity, int size) {
        String sqlKey = entity != null ? entity.getName() + size : "" + size;
        String sql = this.insertSqlMap.get(sqlKey);
        if (sql != null) {
            return sql;
        }
        this.generateInsertSql(entity, size);
        return this.insertSqlMap.get(sqlKey);
    }

    public AbstractLocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPkColumnNames() {
        return Collections.emptySet();
    }

    public String getQName() {
        return Joiner.on((String)".").skipNulls().join((Object)this.schema, (Object)this.name, new Object[0]);
    }

    public String getSchema() {
        return this.schema;
    }

    public AbstractColumn[] getSelectVersionColumns() {
        return this.selectVersionColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectVersionSql(Map<String, AbstractColumn> pkColumns) {
        FinalWrapper<String> wrapper = this.versionSelectSql;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.versionSelectSql == null) {
                    AbstractColumn versionColumn = null;
                    for (AbstractColumn column : this.getColumns()) {
                        AttributeImpl<?, ?> attribute;
                        if (column instanceof DiscriminatorColumn || !((attribute = column.getMapping().getAttribute()) instanceof BasicAttribute) || !((BasicAttribute)attribute).isVersion()) continue;
                        versionColumn = column;
                        break;
                    }
                    final ArrayList selectVersionColumns = Lists.newArrayList();
                    Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                        public String apply(AbstractColumn input) {
                            selectVersionColumns.add(input);
                            return input.getName() + " = ?";
                        }
                    });
                    String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
                    if (versionColumn != null) {
                        this.versionSelectSql = new FinalWrapper<String>("SELECT " + versionColumn.getName() + " FROM " + this.getQName() + "\nWHERE " + restrictionStr);
                        this.selectVersionColumns = selectVersionColumns.toArray(new AbstractColumn[selectVersionColumns.size()]);
                    }
                }
                wrapper = this.versionSelectSql;
            }
        }
        return (String)wrapper.value;
    }

    public Map<String, String[]> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected AbstractColumn[] getUpdateColumns(EntityTypeImpl<?> entity) {
        if (entity == null) {
            return this.updateColumns;
        }
        return this.updateColumnsMap.get(entity);
    }

    protected String getUpdateSql(EntityTypeImpl<?> entity, Map<String, AbstractColumn> pkColumns) {
        if (entity == null) {
            if (this.updateSql == null) {
                this.generateUpdateSql(null, pkColumns);
            }
            return this.updateSql;
        }
        String sql = this.updateSqlMap.get(entity);
        if (sql == null) {
            this.generateUpdateSql(entity, pkColumns);
            sql = this.updateSqlMap.get(entity);
        }
        return sql;
    }

    public AbstractColumn[] getVersionUpdateColumns() {
        return this.versionUpdateColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getVersionUpdateSql(Map<String, AbstractColumn> pkColumns) {
        FinalWrapper<String> wrapper = this.versionUpdateSql;
        if (wrapper == null) {
            AbstractTable abstractTable = this;
            synchronized (abstractTable) {
                if (this.versionUpdateSql == null) {
                    final ArrayList versionUpdateColumns = Lists.newArrayList();
                    for (AbstractColumn column : this.getColumns()) {
                        AttributeImpl<?, ?> attribute = column.getMapping().getAttribute();
                        if (!(attribute instanceof BasicAttribute) || !((BasicAttribute)attribute).isVersion()) continue;
                        versionUpdateColumns.add(column);
                        break;
                    }
                    Collection restrictions = Collections2.transform(pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                        public String apply(AbstractColumn input) {
                            versionUpdateColumns.add(input);
                            return input.getName() + " = ?";
                        }
                    });
                    String columnNamesStr = ((AbstractColumn)versionUpdateColumns.get(0)).getName() + " = ?";
                    String restrictionStr = Joiner.on((String)" AND ").join((Iterable)restrictions);
                    this.versionUpdateSql = new FinalWrapper<String>("UPDATE " + this.getQName() + " SET" + "\n" + columnNamesStr + "\nWHERE " + restrictionStr);
                    this.versionUpdateColumns = versionUpdateColumns.toArray(new AbstractColumn[versionUpdateColumns.size()]);
                }
                wrapper = this.versionUpdateSql;
            }
        }
        return (String)wrapper.value;
    }

    private boolean isInsertableColumn(EntityTypeImpl<?> type, AbstractColumn input) {
        EntityTypeImpl root;
        if (input.getIdType() == IdType.IDENTITY) {
            return false;
        }
        if (!input.isInsertable()) {
            return false;
        }
        if (input instanceof DiscriminatorColumn) {
            return true;
        }
        if (input instanceof JoinColumn && input.getMapping() == null) {
            root = (EntityTypeImpl)((JoinColumn)input).getReferencedColumn().getMapping().getRoot().getType();
        } else {
            if (input instanceof OrderColumn) {
                return input.isInsertable();
            }
            root = (EntityTypeImpl)input.getMapping().getRoot().getType();
        }
        Class parent = root.getJavaType();
        Class javaType = type.getJavaType();
        return parent.isAssignableFrom(javaType);
    }

    private boolean isUpdatableColumn(EntityTypeImpl<?> type, AbstractColumn input) {
        if (input.isPrimaryKey() || input instanceof DiscriminatorColumn) {
            return false;
        }
        if (!input.isUpdatable()) {
            return false;
        }
        EntityTypeImpl root = input instanceof JoinColumn && input.getMapping() == null ? (EntityTypeImpl)((JoinColumn)input).getReferencedColumn().getMapping().getRoot().getType() : (EntityTypeImpl)input.getMapping().getRoot().getType();
        Class parent = root.getJavaType();
        Class javaType = type.getJavaType();
        return parent.isAssignableFrom(javaType);
    }

    protected void setName(String name) {
        this.name = name;
    }
}

