/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.sql.Connection;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class BasicColumn
extends AbstractColumn {
    private AbstractTable table;
    private final int sqlType;
    private final String name;
    private final String columnDefinition;
    private final int length;
    private final int precision;
    private final int scale;
    private final String tableName;
    private final boolean nullable;
    private final boolean insertable;
    private final boolean unique;
    private final boolean updatable;
    private final BasicMapping<?, ?> mapping;
    private final JdbcAdaptor jdbcAdaptor;

    public BasicColumn(JdbcAdaptor jdbcAdaptor, BasicMapping<?, ?> mapping, int sqlType, ColumnMetadata metadata) {
        super(mapping.getAttribute().getJavaType(), mapping.getIdType(), ((BasicAttribute)mapping.getAttribute()).getTemporalType(), ((BasicAttribute)mapping.getAttribute()).getEnumType(), ((BasicAttribute)mapping.getAttribute()).isLob(), mapping.getAttribute().getLocator());
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.sqlType = sqlType;
        this.name = this.jdbcAdaptor.escape(metadata != null && StringUtils.isNotBlank((String)metadata.getName()) ? metadata.getName() : this.mapping.getAttribute().getName());
        this.tableName = metadata != null ? metadata.getTable() : "";
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : "";
        this.length = metadata != null ? metadata.getLength() : 255;
        this.precision = metadata != null ? metadata.getPrecision() : 0;
        this.scale = metadata != null ? metadata.getScale() : 0;
        this.insertable = metadata != null ? metadata.isInsertable() : true;
        this.nullable = metadata != null ? metadata.isNullable() : true;
        this.unique = metadata != null ? metadata.isUnique() : false;
        this.updatable = metadata != null ? metadata.isUpdatable() : true;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public BasicMapping<?, ?> getMapping() {
        return this.mapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getValue(Connection connection, Object instance) {
        return this.convertValue(connection, this.mapping.get(instance));
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setTable(AbstractTable table) {
        this.table = table;
        this.table.addColumn(this);
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.mapping.set(instance, this.convertValueForSet(value));
    }
}

