/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.PoolUtil;
import com.jolbox.bonecp.UsernamePassword;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.batoo.common.util.FinalWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoneCPDataSource
extends BoneCPConfig
implements DataSource,
ObjectFactory {
    private static final long serialVersionUID = -1561804548443209469L;
    private transient PrintWriter logWriter = null;
    private FinalWrapper<BoneCP> pool;
    private String driverClass;
    private static final Logger logger = LoggerFactory.getLogger(BoneCPDataSource.class);
    private final transient Map<UsernamePassword, BoneCPDataSource> multiDataSource = new MapMaker().makeComputingMap((Function)new Function<UsernamePassword, BoneCPDataSource>(){

        public BoneCPDataSource apply(UsernamePassword key) {
            BoneCPDataSource ds = null;
            ds = new BoneCPDataSource(BoneCPDataSource.this.getConfig());
            ds.setUsername(key.getUsername());
            ds.setPassword(key.getPassword());
            return ds;
        }
    });

    public BoneCPDataSource() {
    }

    public BoneCPDataSource(BoneCPConfig config) {
        Field[] fields;
        for (Field field : fields = BoneCPConfig.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(this, field.get(config));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.pool != null) {
            ((BoneCP)this.pool.value).shutdown();
            this.pool = null;
        }
    }

    public BoneCPConfig getConfig() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        FinalWrapper<BoneCP> wrapper = this.pool;
        if (wrapper == null) {
            BoneCPDataSource boneCPDataSource = this;
            synchronized (boneCPDataSource) {
                if (this.pool == null) {
                    this.maybeInit();
                }
                wrapper = this.pool;
            }
        }
        return ((BoneCP)wrapper.value).getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.multiDataSource.get(new UsernamePassword(username, password)).getConnection();
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("getLoginTimeout is unsupported.");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> table) throws Exception {
        Reference ref = (Reference)object;
        Enumeration<RefAddr> addrs = ref.getAll();
        Properties props = new Properties();
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            if (addr.getType().equals("driverClassName")) {
                Class.forName((String)addr.getContent());
                continue;
            }
            props.put(addr.getType(), addr.getContent());
        }
        BoneCPConfig config = new BoneCPConfig(props);
        return new BoneCPDataSource(config);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public int getTotalLeased() {
        return ((BoneCP)this.pool.value).getTotalLeased();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    private void maybeInit() throws SQLException {
        try {
            if (this.getDriverClass() != null) {
                this.loadClass(this.getDriverClass());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(PoolUtil.stringifyException((Throwable)e));
        }
        logger.debug(this.toString());
        this.pool = new FinalWrapper<BoneCP>(new BoneCP((BoneCPConfig)this));
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout is unsupported.");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

