/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.batoo.jpa.core.impl.jdbc.BoneCPDataSource;
import org.batoo.jpa.core.impl.jdbc.ConnectionProxy;
import org.batoo.jpa.core.impl.jdbc.PreparedStatementProxy;

public class DataSourceProxy
implements DataSource {
    private final PreparedStatementProxy.SqlLoggingType sqlLogging;
    private final long slowSqlThreshold;
    private final int jdbcFetchSize;
    private final DataSource datasource;

    public DataSourceProxy(DataSource datasource, PreparedStatementProxy.SqlLoggingType sqlLogging, long slowSqlThreshold, int jdbcFetchSize) {
        this.datasource = datasource;
        this.sqlLogging = sqlLogging;
        this.slowSqlThreshold = slowSqlThreshold;
        this.jdbcFetchSize = jdbcFetchSize;
    }

    public void close() {
        if (this.datasource instanceof BoneCPDataSource) {
            ((BoneCPDataSource)this.datasource).close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionProxy(this.datasource.getConnection(), this.slowSqlThreshold, this.sqlLogging, this.jdbcFetchSize);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new ConnectionProxy(this.datasource.getConnection(username, password), this.slowSqlThreshold, this.sqlLogging, this.jdbcFetchSize);
    }

    public DataSource getDelegate() {
        return this.datasource;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.datasource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.datasource.getLogWriter();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.datasource.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.datasource.isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.datasource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.datasource.setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.datasource.unwrap(iface);
    }
}

