/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import javax.persistence.criteria.JoinType;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.Joinable;
import org.batoo.jpa.core.impl.jdbc.JoinableTable;
import org.batoo.jpa.core.impl.jdbc.MapKeyColumn;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinTableMetadata;

public class JoinTable
extends AbstractTable
implements JoinableTable {
    private final JdbcAdaptor jdbcAdaptor;
    private final ForeignKey sourceKey;
    private final ForeignKey destinationKey;
    private final EntityTypeImpl<?> entity;
    private OrderColumn orderColumn;
    private FinalWrapper<String> removeSql;
    private FinalWrapper<String> removeAllSql;
    private JoinColumn[] sourceRemoveColumns;
    private JoinColumn[] destinationRemoveColumns;
    private JoinColumn[] removeAllColumns;

    public JoinTable(EntityTypeImpl<?> entity, JoinTableMetadata metadata) {
        super(metadata);
        this.entity = entity;
        this.jdbcAdaptor = this.entity.getMetamodel().getJdbcAdaptor();
        this.sourceKey = new ForeignKey(this.jdbcAdaptor, metadata != null ? metadata.getJoinColumns() : Collections.emptyList());
        this.destinationKey = new ForeignKey(this.jdbcAdaptor, metadata != null ? metadata.getInverseJoinColumns() : Collections.emptyList());
    }

    public String createJoin(JoinType joinType, String parentAlias, String alias, boolean forward) {
        String destinationJoin;
        String sourceJoin;
        if (forward) {
            sourceJoin = this.sourceKey.createSourceJoin(joinType, parentAlias, alias + "_J");
            destinationJoin = this.destinationKey.createDestinationJoin(joinType, alias + "_J", alias);
        } else {
            sourceJoin = this.destinationKey.createSourceJoin(joinType, parentAlias, alias + "_J");
            destinationJoin = this.sourceKey.createDestinationJoin(joinType, alias + "_J", alias);
        }
        return sourceJoin + "\n" + destinationJoin;
    }

    public ForeignKey getDestinationKey() {
        return this.destinationKey;
    }

    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    public OrderColumn getOrderColumn() {
        return this.orderColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveAllSql() {
        FinalWrapper<String> wrapper = this.removeAllSql;
        if (wrapper == null) {
            JoinTable joinTable = this;
            synchronized (joinTable) {
                if (this.removeAllSql == null) {
                    ArrayList restrictions = Lists.newArrayList();
                    this.removeAllColumns = new JoinColumn[this.sourceKey.getJoinColumns().size()];
                    int i = 0;
                    for (JoinColumn column : this.sourceKey.getJoinColumns()) {
                        restrictions.add(column.getName() + " = ?");
                        this.removeAllColumns[i++] = column;
                    }
                    this.removeAllSql = new FinalWrapper<String>("DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions));
                }
                wrapper = this.removeAllSql;
            }
        }
        return (String)wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql() {
        FinalWrapper<String> wrapper = this.removeSql;
        if (wrapper == null) {
            JoinTable joinTable = this;
            synchronized (joinTable) {
                if (this.removeSql == null) {
                    ArrayList restrictions = Lists.newArrayList();
                    this.sourceRemoveColumns = new JoinColumn[this.sourceKey.getJoinColumns().size()];
                    this.destinationRemoveColumns = new JoinColumn[this.sourceKey.getJoinColumns().size()];
                    int i = 0;
                    for (JoinColumn column : this.sourceKey.getJoinColumns()) {
                        restrictions.add(column.getName() + " = ?");
                        this.sourceRemoveColumns[i++] = column;
                    }
                    i = 0;
                    for (JoinColumn column : this.destinationKey.getJoinColumns()) {
                        restrictions.add(column.getName() + " = ?");
                        this.destinationRemoveColumns[i++] = column;
                    }
                    this.removeSql = new FinalWrapper<String>("DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions));
                }
                wrapper = this.removeSql;
            }
        }
        return (String)wrapper.value;
    }

    public ForeignKey getSourceKey() {
        return this.sourceKey;
    }

    public void link(EntityTypeImpl<?> source, EntityTypeImpl<?> destination) {
        if (this.getName() == null) {
            this.setName(source.getName() + "_" + destination.getName());
        }
        this.sourceKey.link(null, source);
        this.destinationKey.link(null, destination);
        this.sourceKey.setTable(this);
        this.destinationKey.setTable(this);
    }

    @Override
    public void performInsert(Connection connection, Object source, Joinable[] batch, int size) throws SQLException {
        String insertSql = this.getInsertSql(null, size);
        AbstractColumn[] insertColumns = this.getInsertColumns(null, size);
        Object[] params = new Object[insertColumns.length * size];
        int paramIndex = 0;
        for (int i = 0; i < size; ++i) {
            for (AbstractColumn column : insertColumns) {
                Joinable joinable = batch[i];
                Object destination = joinable.getValue();
                int order = joinable.getIndex();
                Object object = this.sourceKey.getJoinColumns().contains(column) ? source : destination;
                params[paramIndex++] = column != this.orderColumn ? column.getValue(connection, object) : Integer.valueOf(order);
            }
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false).update(connection, insertSql, params);
    }

    @Override
    public void performRemove(Connection connection, Object source, Object key, Object destination) throws SQLException {
        String removeSql = this.getRemoveSql();
        Object[] params = new Object[this.sourceKey.getJoinColumns().size() + this.destinationKey.getJoinColumns().size()];
        int i = 0;
        for (JoinColumn sourceRemoveColumn : this.sourceRemoveColumns) {
            params[i++] = sourceRemoveColumn.getValue(connection, source);
        }
        for (JoinColumn destinationRemoveColumn : this.destinationRemoveColumns) {
            params[i++] = destinationRemoveColumn.getValue(connection, destination);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false).update(connection, removeSql, params);
    }

    @Override
    public void performRemoveAll(Connection connection, Object source) throws SQLException {
        String removeAllSql = this.getRemoveAllSql();
        Object[] params = new Object[this.removeAllColumns.length];
        int i = 0;
        for (JoinColumn sourceRemoveColumn : this.removeAllColumns) {
            params[i++] = sourceRemoveColumn.getValue(connection, source);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false).update(connection, removeAllSql, params);
    }

    public void setKeyColumn(ColumnMetadata mapKeyColumn, String name, TemporalType mapKeyTemporalType, EnumType mapKeyEnumType, Class<?> mapKeyJavaType) {
        new MapKeyColumn(this, mapKeyColumn, name, mapKeyTemporalType, mapKeyEnumType, mapKeyJavaType);
    }

    public void setOrderColumn(ColumnMetadata orderColumn, String name, AbstractLocator locator) {
        this.orderColumn = new OrderColumn(this, orderColumn, name, locator);
    }
}

