/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import javax.persistence.PersistenceUnitUtil;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class PersistenceUnitUtilImpl
implements PersistenceUnitUtil {
    private final EntityManagerFactoryImpl emf;

    public PersistenceUnitUtilImpl(EntityManagerFactoryImpl entityManagerFactory) {
        this.emf = entityManagerFactory;
    }

    public Object getIdentifier(Object entity) {
        EntityTypeImpl<?> type = this.emf.getMetamodel().getEntity(entity.getClass());
        return type.getInstanceId(entity);
    }

    public boolean isLoaded(Object entity) {
        if (entity instanceof EnhancedInstance) {
            EnhancedInstance instance = (EnhancedInstance)entity;
            return instance.__enhanced__$$__isInitialized();
        }
        return true;
    }

    public boolean isLoaded(Object entity, String attributeName) {
        if (entity == null || StringUtils.isBlank((String)attributeName)) {
            throw new NullPointerException();
        }
        if (entity instanceof EnhancedInstance) {
            EnhancedInstance instance = (EnhancedInstance)entity;
            if (instance.__enhanced__$$__getManagedInstance() != null) {
                return instance.__enhanced__$$__getManagedInstance().isJoinLoaded(attributeName);
            }
            try {
                Object value = entity.getClass().getMethod("get" + StringUtils.capitalize((String)attributeName), new Class[0]).invoke(entity, new Object[0]);
                if (value instanceof EnhancedInstance) {
                    return this.isLoaded(value);
                }
                if (value instanceof ManagedCollection) {
                    return ((ManagedCollection)value).isInitialized();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to get attribute " + attributeName);
            }
        }
        return true;
    }
}

