/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.EntityType;
import javax.validation.ConstraintViolationException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.cache.CacheImpl;
import org.batoo.jpa.core.impl.cache.CacheInstance;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Prioritizer;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;

public class SessionImpl {
    private static final BLogger LOG = BLoggerFactory.getLogger(SessionImpl.class);
    private final EntityManagerImpl em;
    private final MetamodelImpl metamodel;
    private final HashMap<ManagedId<?>, ManagedInstance<?>> repository = Maps.newHashMap();
    private final ArrayList<ManagedInstance<?>> newEntities = Lists.newArrayList();
    private final ArrayList<ManagedInstance<?>> externalEntities = Lists.newArrayList();
    private final HashSet<ManagedInstance<?>> changedEntities = Sets.newHashSet();
    private List<ManagedInstance<?>> entitiesLoading = Lists.newArrayList();
    private Set<ManagedId<?>> idsNotCached = Sets.newHashSet();
    private int loadTracker = 0;
    private final int insertBatchSize;
    private final int removeBatchSize;

    public SessionImpl(EntityManagerImpl entityManager, MetamodelImpl metamodel) {
        this.em = entityManager;
        this.metamodel = metamodel;
        this.insertBatchSize = this.em.getJdbcAdaptor().getInsertBatchSize();
        this.removeBatchSize = this.em.getJdbcAdaptor().getRemoveBatchSize();
    }

    public void cascadeRemovals(ManagedInstance<?>[] instances) {
        LOG.debug("Cascading removals on session {0}", this);
        for (ManagedInstance<?> instance : instances) {
            if (instance.getStatus() != Status.REMOVED) continue;
            instance.cascadeRemove(this.em);
        }
    }

    public void checkTransient(Object instance) {
        ManagedInstance<?> associate;
        if (instance instanceof EnhancedInstance ? (associate = ((EnhancedInstance)instance).__enhanced__$$__getManagedInstance()).getStatus() != Status.MANAGED && associate.getSession() == this : (associate = this.get(instance)) == null || associate.getStatus() != Status.MANAGED) {
            throw new PersistenceException("Instance " + instance + " is not managed");
        }
    }

    public void clear() {
        LOG.debug("Session clearing {0}", this);
        this.repository.clear();
        this.externalEntities.clear();
        this.changedEntities.clear();
    }

    private void doRemoves(Connection connection, ManagedInstance<?>[] removes) throws SQLException {
        ManagedInstance[] batch = new ManagedInstance[this.removeBatchSize];
        int i = 0;
        while (i < removes.length) {
            int batchSize;
            EntityTypeImpl<?> lastEntity = null;
            for (batchSize = 0; i < removes.length && batchSize < this.removeBatchSize && (lastEntity == null || lastEntity == removes[i].getType()); ++batchSize, ++i) {
                lastEntity = removes[i].getType();
                batch[batchSize] = removes[i];
            }
            LOG.debug("Batch remove is being performed for {0} with the size {1}", lastEntity.getName(), batchSize);
            lastEntity.performRemove(connection, batch, batchSize);
            batchSize = 0;
            lastEntity = null;
        }
    }

    private void doUpdates(Connection connection, ManagedInstance<?>[] updates) throws SQLException {
        ManagedInstance[] inserts = new ManagedInstance[this.insertBatchSize];
        int i = 0;
        while (i < updates.length) {
            int batchSize;
            EntityTypeImpl<?> lastEntity = null;
            for (batchSize = 0; i < updates.length && batchSize < this.insertBatchSize && updates[i].getStatus() == Status.NEW && (lastEntity == null || lastEntity == updates[i].getType()); ++batchSize, ++i) {
                if (lastEntity == null) {
                    if (!updates[i].getType().isSuitableForBatchInsert()) break;
                    lastEntity = updates[i].getType();
                }
                inserts[batchSize] = updates[i];
            }
            if (batchSize > 0) {
                LOG.debug("Batch insert is being performed for {0} with the size {1}", lastEntity.getName(), batchSize);
                lastEntity.performInsert(connection, inserts, batchSize);
                continue;
            }
            ManagedInstance<?> instance = updates[i];
            if (instance.getStatus() == Status.NEW) {
                inserts[0] = instance;
                instance.getType().performInsert(connection, inserts, 1);
            } else {
                instance.getType().performUpdate(connection, instance);
            }
            ++i;
        }
    }

    private void doVersionChecks(Connection connection, ManagedInstance<?>[] removals, ManagedInstance<?>[] updates) throws SQLException {
        LOG.debug("Performing version checks on session {0}", this);
        for (ManagedInstance<?> instance : removals) {
            instance.checkVersion(connection);
        }
        for (ManagedInstance<?> instance : updates) {
            instance.checkVersion(connection);
        }
    }

    private void doVersionUpgrades(Connection connection, ManagedInstance<?>[] updates) throws SQLException {
        LOG.debug("Performing version upgrades on session {0}", this);
        for (ManagedInstance<?> instance : updates) {
            instance.incrementVersion(connection, false);
        }
    }

    private void firePostCallbacks(ManagedInstance<?>[] updates, ManagedInstance<?>[] removals, CallbackAvailability callbackAvailability) {
        if (callbackAvailability.postRemove()) {
            for (ManagedInstance<?> instance : removals) {
                instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.POST_REMOVE);
            }
        }
        if (callbackAvailability.postWrite()) {
            for (ManagedInstance<?> instance : updates) {
                instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.POST_UPDATE);
            }
        }
    }

    private void firePreCallbacks(ManagedInstance<?>[] sortedUpdates, ManagedInstance<?>[] sortedRemovals, CallbackAvailability callbackAvailability) {
        if (callbackAvailability.preRemove()) {
            for (ManagedInstance<?> instance : sortedRemovals) {
                instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.PRE_REMOVE);
            }
        }
        if (callbackAvailability.preWrite()) {
            for (ManagedInstance<?> instance : sortedUpdates) {
                instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.PRE_UPDATE);
            }
        }
    }

    public void flush(Connection connection) throws SQLException {
        LOG.debug("Flushing session {0}", this);
        ArrayList updates = Lists.newArrayList(this.newEntities);
        ArrayList removals = Lists.newArrayListWithCapacity((int)this.changedEntities.size());
        for (ManagedInstance<?> instance : this.changedEntities) {
            if (instance.getStatus() == Status.NEW) continue;
            if (instance.getStatus() == Status.REMOVED) {
                removals.add(instance);
                continue;
            }
            if (!instance.hasSelfUpdate()) continue;
            updates.add(instance);
        }
        if (updates.size() == 0 && removals.size() == 0) {
            return;
        }
        ManagedInstance[] sortedUpdates = new ManagedInstance[updates.size()];
        ManagedInstance[] sortedRemovals = new ManagedInstance[removals.size()];
        CallbackAvailability callbackAvailability = new CallbackAvailability();
        Prioritizer.sort(updates, removals, sortedUpdates, sortedRemovals, callbackAvailability);
        LOG.debug("Flushing session {0}: updates {1}, removals {2}", this, sortedUpdates.length, sortedRemovals.length);
        EntityManagerFactoryImpl entityManagerFactory = this.em.getEntityManagerFactory();
        if (entityManagerFactory.hasValidators()) {
            HashSet violations = Sets.newHashSet();
            for (ManagedInstance instance : sortedUpdates) {
                violations.addAll(instance.getType().runValidators(entityManagerFactory, instance));
            }
            for (ManagedInstance instance : sortedRemovals) {
                violations.addAll(instance.getType().runValidators(entityManagerFactory, instance));
            }
            if (violations.size() > 0) {
                throw new ConstraintViolationException("Cannot flush due to validation errors.", (Set)violations);
            }
        }
        this.firePreCallbacks(sortedUpdates, sortedRemovals, callbackAvailability);
        this.doVersionChecks(connection, sortedRemovals, sortedUpdates);
        this.doVersionUpgrades(connection, sortedUpdates);
        for (ManagedInstance instance : sortedRemovals) {
            instance.flushAssociations(connection, true, false);
        }
        for (ManagedInstance instance : sortedUpdates) {
            instance.flushAssociations(connection, true, false);
        }
        this.doRemoves(connection, sortedRemovals);
        this.doUpdates(connection, sortedUpdates);
        for (ManagedInstance instance : sortedUpdates) {
            instance.checkTransients();
        }
        for (ManagedInstance instance : sortedUpdates) {
            instance.flushAssociations(connection, false, this.newEntities.contains(instance));
            instance.sortLists();
            instance.reset();
        }
        this.firePostCallbacks(sortedUpdates, sortedRemovals, callbackAvailability);
        LOG.debug("Flush successful for session {0}", this);
        this.putInstancesToCache(this.em.getEntityManagerFactory().getCache(), sortedUpdates, sortedRemovals);
        this.externalEntities.addAll(this.newEntities);
        for (int i = 0; i < this.newEntities.size(); ++i) {
            ManagedInstance<?> instance = this.newEntities.get(i);
            if (instance.hasInitialId()) continue;
            this.repository.put(instance.getId(), instance);
        }
        this.changedEntities.clear();
        this.newEntities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Y, X> ManagedInstance<Y> get(ManagedId<X> id) {
        ManagedInstance<Object> instance = this.repository.get(id);
        if (instance != null) {
            return instance;
        }
        CacheImpl cache = this.em.getEntityManagerFactory().getCache();
        if (cache.getCacheRetrieveMode(id.getType()) == CacheRetrieveMode.USE) {
            if (this.idsNotCached.contains(id)) {
                return null;
            }
            CacheInstance cacheInstance = cache.get(id);
            if (cacheInstance != null) {
                EntityTypeImpl<X> type = this.metamodel.entity(cacheInstance.getEntityName());
                instance = type.getManagedInstanceById(this, id, false);
                cacheInstance.copyTo(cache, instance);
                instance.enhanceCollections();
                this.setLoadTracker();
                try {
                    this.put(instance);
                }
                finally {
                    this.releaseLoadTracker();
                }
                return instance;
            }
            if (instance == null) {
                this.idsNotCached.add(id);
            }
        }
        return instance;
    }

    public <X> ManagedInstance<X> get(X entity) {
        EntityType type;
        Class<?> clazz = null;
        if (entity instanceof EnhancedInstance) {
            ManagedInstance<?> instance = ((EnhancedInstance)entity).__enhanced__$$__getManagedInstance();
            if (instance != null && instance.getSession() == this) {
                return instance;
            }
            clazz = entity.getClass().getSuperclass();
        }
        if (clazz == null) {
            clazz = entity.getClass();
        }
        if ((type = this.metamodel.entity(clazz)) == null) {
            throw new PersistenceException(entity.getClass().getName() + " is not a persistence class");
        }
        ManagedId id = type.getId(entity);
        return this.repository.get(id);
    }

    public EntityManagerImpl getEntityManager() {
        return this.em;
    }

    public ManagedInstance<?>[] handleAdditions() {
        ManagedInstance[] instances;
        LOG.debug("Processing additions to the session {0}", this);
        for (ManagedInstance instance : instances = this.changedEntities.toArray(new ManagedInstance[this.changedEntities.size()])) {
            instance.handleAdditions(this.em);
        }
        return instances;
    }

    public void handleExternals() {
        LOG.debug("Inspecting updated external entities on session {0}", this);
        for (int i = 0; i < this.externalEntities.size(); ++i) {
            this.externalEntities.get(i).checkUpdated();
        }
    }

    public void handleOrphans(ManagedInstance<?>[] instances) {
        LOG.debug("Inspecting orphan on session {0}", this);
        for (ManagedInstance<?> instance : instances) {
            if (instance.getStatus() == Status.REMOVED) continue;
            instance.handleOrphans(this.em);
        }
    }

    public void lazyInstanceLoading(ManagedInstance<?> instance) {
        LOG.debug("Lazy instance is being loaded {0}", instance);
        this.entitiesLoading.add(instance);
    }

    public <X> void put(ManagedInstance<X> instance) {
        this.repository.put(instance.getId(), instance);
        if (this.loadTracker > 0 && instance.isLoading()) {
            this.entitiesLoading.add(instance);
        }
    }

    public <X> void putExternal(ManagedInstance<X> instance) {
        if (instance.hasInitialId()) {
            this.repository.put(instance.getId(), instance);
        }
        this.newEntities.add(instance);
    }

    private void putInstancesToCache(CacheImpl cache, ManagedInstance<?>[] sortedUpdates, ManagedInstance<?>[] sortedRemovals) {
        if (!cache.isOn()) {
            return;
        }
        for (ManagedInstance<?> instance : sortedRemovals) {
            cache.put(instance);
        }
        for (ManagedInstance<?> instance : sortedUpdates) {
            if (cache.getCacheStoreMode(instance.getType()) != CacheStoreMode.USE) continue;
            cache.put(instance);
        }
    }

    public void releaseLoadTracker() {
        --this.loadTracker;
        if (this.loadTracker == 0) {
            CacheImpl cache = this.getEntityManager().getEntityManagerFactory().getCache();
            LOG.debug("Load tracker is released on session {0}", this);
            ManagedInstance[] entitiesLoaded = this.entitiesLoading.toArray(new ManagedInstance[this.entitiesLoading.size()]);
            this.entitiesLoading = Lists.newArrayList();
            this.idsNotCached = Sets.newHashSet();
            for (ManagedInstance instance : entitiesLoaded) {
                if (this.em.hasTransactionMarkedForRollback()) {
                    return;
                }
                instance.setLoading(false);
                instance.processJoinedMappings();
                instance.sortLists();
                if (!instance.isLoadingFromCache() && cache.getCacheStoreMode(instance.getType()) != CacheStoreMode.BYPASS) {
                    cache.put(instance);
                }
                instance.setLoadingFromCache(false);
            }
            for (ManagedInstance instance : entitiesLoaded) {
                instance.fireCallbacks(EntityListenerMetadata.EntityListenerType.POST_LOAD);
            }
        }
    }

    public ManagedInstance<?> remove(Object entity) {
        EntityType type = this.metamodel.entity(entity.getClass());
        ManagedId instanceId = type.getId(entity);
        ManagedInstance<?> instance = this.repository.get(instanceId);
        if (instance != null) {
            this.repository.remove(instanceId);
            this.changedEntities.remove(instance);
            this.externalEntities.remove(instance);
            this.newEntities.remove(instance);
        }
        return instance;
    }

    public void setChanged(ManagedInstance<?> instance) {
        this.changedEntities.add(instance);
        if (instance.getStatus() == Status.REMOVED) {
            this.externalEntities.remove(instance);
        }
    }

    public void setLoadTracker() {
        ++this.loadTracker;
        if (this.loadTracker == 1) {
            LOG.debug("Load tracker is triggered on session {0}", this);
        }
    }
}

