/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model;

import com.google.common.base.Joiner;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.model.AbstractGenerator;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;

public class TableGenerator
extends AbstractGenerator {
    private static final String DEFAULT_PK_COLUMN_NAME = "NAME";
    private static final String DEFAULT_TABLE_NAME = "BATOO_ID";
    private static final String DEFAULT_VALUE_COLUMN_NAME = "NEXT_ID";
    private final String pkColumnName;
    private final String pkColumnValue;
    private final String table;
    private final String valueColumnName;

    public TableGenerator(TableGeneratorMetadata metadata) {
        super(metadata);
        this.table = metadata != null && StringUtils.isNotBlank((String)metadata.getTable()) ? metadata.getTable() : DEFAULT_TABLE_NAME;
        this.pkColumnName = metadata != null && StringUtils.isNotBlank((String)metadata.getPkColumnName()) ? metadata.getPkColumnName() : DEFAULT_PK_COLUMN_NAME;
        String string = this.valueColumnName = metadata != null && StringUtils.isNotBlank((String)metadata.getValueColumnName()) ? metadata.getValueColumnName() : DEFAULT_VALUE_COLUMN_NAME;
        this.pkColumnValue = metadata != null ? (StringUtils.isNotBlank((String)metadata.getPkColumnValue()) ? metadata.getPkColumnValue() : (StringUtils.isNotBlank((String)metadata.getName()) ? metadata.getName() : DEFAULT_TABLE_NAME)) : DEFAULT_TABLE_NAME;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public String getQName() {
        return Joiner.on((String)".").skipNulls().join((Object)this.getSchema(), (Object)this.table, new Object[0]);
    }

    public String getTable() {
        return this.table;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }
}

