/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.attribute;

import java.lang.reflect.Member;
import javax.persistence.metamodel.Attribute;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.attribute.AttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.attribute.AttributeMetadata;

public abstract class AttributeImpl<X, Y>
implements Attribute<X, Y> {
    private static int nextAttributeId;
    private final int attributeId = AttributeImpl.nextAttributeId();
    private final AttributeMetadata metadata;
    private final ManagedTypeImpl<X> declaringType;
    private final String name;
    private final Member javaMember;
    private final Class<Y> javaType;
    private final MetamodelImpl metamodel;
    private final AbstractAccessor accessor;

    private static int nextAttributeId() {
        return nextAttributeId++;
    }

    public AttributeImpl(ManagedTypeImpl<X> declaringType, AttributeMetadata metadata) {
        this.metadata = metadata;
        this.declaringType = declaringType;
        this.name = metadata.getName();
        this.javaMember = ((AttributeMetadataImpl)metadata).getMember();
        this.javaType = ReflectHelper.getMemberType(this.javaMember);
        this.metamodel = declaringType.getMetamodel();
        this.accessor = ReflectHelper.getAccessor(this.javaMember);
    }

    public Y get(Object instance) {
        if (instance == null) {
            return null;
        }
        return (Y)this.accessor.get(instance);
    }

    public Integer getAttributeId() {
        return this.attributeId;
    }

    public ManagedTypeImpl<X> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.javaMember;
    }

    public Class<Y> getJavaType() {
        return this.javaType;
    }

    public AbstractLocator getLocator() {
        return this.metadata.getLocator();
    }

    public AttributeMetadata getMetadata() {
        return this.metadata;
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public String getName() {
        return this.name;
    }

    public void set(Object instance, Object value) {
        this.accessor.set(instance, value);
    }
}

