/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.ObjectUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;

public class ListComparator<E>
implements Comparator<E> {
    private static final BLogger LOG = BLoggerFactory.getLogger(ListComparator.class);
    private final PluralMapping<?, ?, E> mapping;
    private final ArrayList<ComparableMapping> comparables = Lists.newArrayList();

    public ListComparator(PluralMapping<?, ?, E> mapping) {
        this.mapping = mapping;
        this.createComparables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(E o1, E o2) {
        int n;
        block4: {
            int result = 0;
            try {
                for (int i = 0; i < this.comparables.size(); ++i) {
                    Object v2;
                    ComparableMapping mapping = this.comparables.get(i);
                    Object v1 = mapping.getMapping().get(o1);
                    result = ObjectUtils.compare((Comparable)((Comparable)v1), (Comparable)((Comparable)(v2 = mapping.getMapping().get(o2))));
                    if (result == 0) continue;
                    if (mapping.isAscending()) break;
                    result = -result;
                    break;
                }
                n = result;
                if (!LOG.isDebugEnabled()) break block4;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{0} {1} {2}", result < 0 ? o1 : o2, result == 0 ? "=" : "<", result < 0 ? o2 : o1);
                }
                throw throwable;
            }
            LOG.debug("{0} {1} {2}", result < 0 ? o1 : o2, result == 0 ? "=" : "<", result < 0 ? o2 : o1);
        }
        return n;
    }

    private void createComparable(SingularMapping<?, ?> idMapping) {
        if (idMapping instanceof BasicMapping) {
            this.comparables.add(new ComparableMapping(true, (Mapping)((Object)idMapping)));
        } else if (idMapping instanceof SingularAssociationMapping) {
            // empty if block
        }
    }

    private void createComparables() {
        if (this.mapping.getOrderBy().trim().length() == 0) {
            if (this.mapping.isAssociation()) {
                TypeImpl type = ((PluralAssociationMapping)this.mapping).getType();
                if (((IdentifiableTypeImpl)type).hasSingleIdAttribute()) {
                    this.createComparable(((EntityTypeImpl)type).getIdMapping());
                } else {
                    for (Pair pair : ((EntityTypeImpl)type).getIdMappings()) {
                        this.createComparable(pair.getFirst());
                    }
                }
            } else {
                if (this.mapping.getType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                    throw new MappingException("Embeddable element collections requires OrderBy value", this.mapping.getAttribute().getLocator());
                }
                this.comparables.add(new ComparableMapping(true, null));
            }
        } else {
            Iterator i = Splitter.on((String)",").trimResults().split((CharSequence)this.mapping.getOrderBy()).iterator();
            while (i.hasNext()) {
                Iterator j = Splitter.on((String)" ").trimResults().split((CharSequence)i.next()).iterator();
                int index = 0;
                String path = null;
                boolean order = true;
                while (j.hasNext()) {
                    if (index == 0) {
                        path = (String)j.next();
                    } else if (index == 1) {
                        order = "ASC".equals(((String)j.next()).toUpperCase());
                    } else {
                        throw new MappingException("Invalid order by statement: " + this.mapping.getOrderBy() + ".", this.mapping.getAttribute().getLocator());
                    }
                    ++index;
                }
                if (this.mapping.getType().getPersistenceType() == Type.PersistenceType.BASIC) {
                    throw new MappingException("Basic element collection must not have OrderBy value", this.mapping.getAttribute().getLocator());
                }
                Mapping<?, ?, ?> mapping = this.mapping.getMapping(path);
                if (mapping == null) {
                    throw new MappingException("Sort property cannot be found: " + path, this.mapping.getAttribute().getLocator());
                }
                this.comparables.add(new ComparableMapping(order, mapping));
            }
        }
    }

    private class ComparableMapping {
        private final boolean ascending;
        private final Mapping<?, ?, ?> mapping;

        public ComparableMapping(boolean ascending, Mapping<?, ?, ?> mapping) {
            this.ascending = ascending;
            this.mapping = mapping;
        }

        protected Mapping<?, ?, ?> getMapping() {
            return this.mapping;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

