/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.nativeQuery;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.NotImplementedException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.nativeQuery.NativeParameter;
import org.batoo.jpa.sql.SqlLexer;
import org.batoo.jpa.sql.SqlParser;

public class NativeQuery
implements Query,
ResultSetHandler<List<Object>> {
    private static final BLogger LOG = BLoggerFactory.getLogger(NativeQuery.class);
    private final EntityManagerImpl em;
    private final String query;
    private final Class<?> resultClass;
    private FlushModeType flushMode;
    private int maxResults;
    private int firstResult;
    private EntityTypeImpl<?> entity;
    private final HashMap<String, NativeParameter<?>> parameters = Maps.newHashMap();
    private final Map<String, Object> hints = Maps.newHashMap();
    private final HashMap<NativeParameter<?>, Object> parameterValues = Maps.newHashMap();
    private List<?> results;

    public NativeQuery(EntityManagerImpl entityManager, String query) {
        this.em = entityManager;
        this.query = this.parseParameters(query);
        this.resultClass = null;
    }

    public NativeQuery(EntityManagerImpl entityManager, String sqlString, Class<?> resultClass) {
        this.em = entityManager;
        this.query = this.parseParameters(sqlString);
        this.resultClass = resultClass;
    }

    private Object convertTemporal(TemporalType temporalType, Calendar value) {
        switch (temporalType) {
            case DATE: {
                return new Date(value.getTimeInMillis());
            }
            case TIME: {
                return new Time(value.getTimeInMillis());
            }
        }
        return new Timestamp(value.getTimeInMillis());
    }

    private Object convertTemporal(TemporalType temporalType, java.util.Date value) {
        switch (temporalType) {
            case DATE: {
                return new Date(value.getTime());
            }
            case TIME: {
                return new Time(value.getTime());
            }
        }
        return new Timestamp(value.getTime());
    }

    public int executeUpdate() {
        this.em.assertTransaction();
        if (this.flushMode == FlushModeType.AUTO || this.em.getFlushMode() == FlushModeType.AUTO) {
            this.em.flush();
        }
        try {
            if (!this.parameters.isEmpty()) {
                Object[] parameters = new Object[this.parameters.size()];
                for (int i = 0; i < this.parameters.size(); ++i) {
                    parameters[i] = this.getParameterValue(i);
                }
                return new QueryRunner(this.em.getJdbcAdaptor().isPmdBroken(), false).update(this.query, parameters);
            }
            return new QueryRunner(this.em.getJdbcAdaptor().isPmdBroken(), false).update(this.query);
        }
        catch (SQLException e) {
            throw new PersistenceException("Native query execution has failed!", (Throwable)e);
        }
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Map<String, Object> getHints() {
        return Collections.unmodifiableMap(this.hints);
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("Locking is not supported in native queries");
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public NativeParameter<?> getParameter(int position) {
        return this.parameters.get(Integer.toString(position));
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new NotImplementedException("Native queries do not define parameter types. Use getParameter(int)");
    }

    public NativeParameter<?> getParameter(String name) {
        return this.parameters.get(name);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        throw new NotImplementedException("Native queries do not define parameter types. Use getParameter(String)");
    }

    public Set<Parameter<?>> getParameters() {
        HashSet parameters = Sets.newHashSet();
        for (NativeParameter<?> parameter : this.parameters.values()) {
            parameters.add(parameter);
        }
        return parameters;
    }

    public Object getParameterValue(int position) {
        return this.parameterValues.get(this.getParameter(position));
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.parameterValues.get(param);
    }

    public Object getParameterValue(String name) {
        return this.parameterValues.get(this.parameters.get(name));
    }

    public List<?> getResultList() {
        if (this.results != null) {
            return this.results;
        }
        return this.getResultListImpl();
    }

    private List<?> getResultListImpl() {
        this.em.getSession().setLoadTracker();
        try {
            if (this.resultClass != null) {
                this.entity = this.em.getMetamodel().entity(this.resultClass);
            }
            Object[] paramValues = new Object[this.parameters.size()];
            for (int i = 0; i < paramValues.length; ++i) {
                paramValues[i] = this.getParameterValue(i + 1);
            }
            try {
                this.results = new QueryRunner(this.em.getJdbcAdaptor().isPmdBroken(), false).query(this.em.getConnection(), this.query, this, paramValues);
                List<Object> i = this.results;
                return i;
            }
            catch (SQLException e) {
                throw new PersistenceException("Native query execution failed!", (Throwable)e);
            }
        }
        finally {
            this.em.getSession().releaseLoadTracker();
        }
    }

    public Object getSingleResult() {
        List<?> resultList = this.getResultList();
        if (resultList.size() > 1) {
            throw new NonUniqueResultException();
        }
        if (resultList.size() == 0) {
            throw new NoResultException();
        }
        return resultList.get(0);
    }

    public List<Object> handle(ResultSet resultSet) throws SQLException {
        if (this.resultClass != null) {
            if (this.entity != null) {
                return this.handleAsEntityList(resultSet);
            }
            return this.handleAsResultClass(resultSet);
        }
        ArrayList results = Lists.newArrayList();
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            if (columnCount == 1) {
                results.add(resultSet.getObject(1));
                continue;
            }
            Object[] result = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                result[i] = resultSet.getObject(i + 1);
            }
            results.add(result);
        }
        return results;
    }

    private List<Object> handleAsEntityList(ResultSet resultSet) throws SQLException {
        ArrayList results = Lists.newArrayList();
        while (resultSet.next()) {
            ManagedInstance<ManagedId<?>> instance;
            SessionImpl session = this.em.getSession();
            ManagedId<?> id = this.entity.getId(resultSet);
            if (id == null || (instance = session.get(id)) == null) continue;
            if (!(instance.getInstance() instanceof EnhancedInstance)) {
                results.add(instance.getInstance());
                continue;
            }
            EnhancedInstance enhancedInstance = (EnhancedInstance)((Object)instance.getInstance());
            if (!enhancedInstance.__enhanced__$$__isInitialized()) {
                this.initializeInstance(session, resultSet, instance);
                session.lazyInstanceLoading(instance);
                enhancedInstance.__enhanced__$$__setInitialized();
            }
            results.add(instance.getInstance());
        }
        return results;
    }

    private List<Object> handleAsResultClass(ResultSet resultSet) {
        return null;
    }

    private void initializeInstance(SessionImpl session, ResultSet row, ManagedInstance<?> managedInstance) throws SQLException {
        managedInstance.setLoading(true);
        Object instance = managedInstance.getInstance();
        for (Mapping<?, ?, ?> mapping : this.entity.getMappingsSingular()) {
            this.initializeMapping(session, instance, row, mapping);
        }
    }

    private void initializeMapping(SessionImpl session, Object instance, ResultSet row, Mapping<?, ?, ?> mapping) throws SQLException {
        if (mapping instanceof BasicMapping) {
            BasicMapping basicMapping = (BasicMapping)mapping;
            BasicColumn column = basicMapping.getColumn();
            column.setValue(instance, row.getObject(column.getName()));
        } else if (mapping instanceof EmbeddedMapping) {
            for (Mapping childMapping : ((EmbeddedMapping)mapping).getChildren()) {
                this.initializeMapping(session, instance, row, childMapping);
            }
        }
    }

    public boolean isBound(Parameter<?> param) {
        return this.getParameterValue(param) != null;
    }

    private CommonTree parse(String query) {
        try {
            SqlLexer lexer = new SqlLexer((CharStream)new ANTLRStringStream(query));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokenStream);
            SqlParser.statements_return statements = parser.statements();
            CommonTree tree = (CommonTree)statements.getTree();
            List<String> errors = parser.getErrors();
            if (errors.size() > 0) {
                String errorMsg = Joiner.on((String)"\n\t").join(errors);
                LOG.error("Cannot parse query: {0}", LOG.boxed(query, new Object[]{"\n\t" + errorMsg, "\n\n" + tree.toStringTree() + "\n"}));
                throw new PersistenceException("Cannot parse the query:\n " + errorMsg + ".\n" + query);
            }
            return tree;
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot parse the query:\n " + e.getMessage() + ".\n" + query, (Throwable)e);
        }
    }

    private String parseParameters(String query) {
        CommonTree tree = this.parse(query);
        boolean hasNamed = false;
        boolean hasOrdinal = false;
        boolean hasAnonymous = false;
        int maxOrdinal = 0;
        StringBuilder sqlBuilder = new StringBuilder();
        if (tree.getChildCount() > 1) {
            throw new PersistenceException("Multi-statement native queries not supported");
        }
        if (tree.getChildCount() == 0) {
            throw new PersistenceException("Null query passed");
        }
        Tree statementTree = tree.getChild(0);
        for (int i = 0; i < statementTree.getChildCount(); ++i) {
            Tree chunk;
            if (i > 0) {
                sqlBuilder.append(' ');
            }
            if ((chunk = statementTree.getChild(i)).getType() == 4) {
                hasNamed = true;
                String name = chunk.getChild(0).getText();
                NativeParameter<Object> parameter = this.parameters.get(name);
                if (parameter == null) {
                    parameter = new NativeParameter(name, maxOrdinal++);
                    this.parameters.put(name, parameter);
                }
                sqlBuilder.append("?" + parameter.getPosition());
                continue;
            }
            if (chunk.getType() == 18) {
                String name;
                if (chunk.getChildCount() == 0) {
                    hasAnonymous = true;
                    NativeParameter parameter = new NativeParameter(maxOrdinal++);
                    name = Integer.toString(maxOrdinal);
                    this.parameters.put(name, parameter);
                    continue;
                }
                hasOrdinal = true;
                int ordinalNo = Integer.parseInt(chunk.getChild(0).getText());
                if (ordinalNo <= 0) {
                    throw new PersistenceException("Invalid ordinal number for parameter: " + ordinalNo + " in query: " + this.query);
                }
                name = Integer.toString(ordinalNo);
                NativeParameter<Object> parameter = this.parameters.get(name);
                if (parameter == null) {
                    parameter = new NativeParameter(ordinalNo);
                    this.parameters.put(name, parameter);
                }
                maxOrdinal = Math.max(maxOrdinal, ordinalNo);
                sqlBuilder.append("?" + parameter.getPosition());
                continue;
            }
            sqlBuilder.append(chunk.getText());
        }
        int types = 0;
        if (hasAnonymous) {
            ++types;
        }
        if (hasNamed) {
            ++types;
        }
        if (hasOrdinal) {
            ++types;
        }
        if (types > 1) {
            throw new PersistenceException("Mix of ordinal, named and anonymous parameters are not allowed in SQL queries: " + this.query);
        }
        if (this.parameters.size() != maxOrdinal) {
            throw new PersistenceException("Query defines ordinal parameter " + maxOrdinal + " but does not define " + maxOrdinal + " parameters");
        }
        return sqlBuilder.toString();
    }

    public NativeQuery setFirstResult(int startPosition) {
        this.firstResult = startPosition;
        return this;
    }

    public NativeQuery setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public NativeQuery setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        return this;
    }

    public NativeQuery setLockMode(LockModeType lockMode) {
        throw new UnsupportedOperationException("Locking is not supported in native queries");
    }

    public NativeQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public NativeQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(position), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(int position, java.util.Date value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(position), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(int position, Object value) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(position), value);
        return this;
    }

    public NativeQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter)param, this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(Parameter<java.util.Date> param, java.util.Date value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter)param, this.convertTemporal(temporalType, value));
        return this;
    }

    public <T> NativeQuery setParameter(Parameter<T> param, T value) {
        this.parameterValues.put((NativeParameter)param, value);
        return this;
    }

    public NativeQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(name), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(String name, java.util.Date value, TemporalType temporalType) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(name), this.convertTemporal(temporalType, value));
        return this;
    }

    public NativeQuery setParameter(String name, Object value) {
        this.parameterValues.put((NativeParameter<?>)this.getParameter(name), value);
        return this;
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }
}

