/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.jdbc.adapter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.jdbc.adapter.JdbcColumn;
import org.batoo.jpa.core.jdbc.adapter.JdbcForeignKey;
import org.batoo.jpa.core.jdbc.adapter.JdbcIndex;

public class JdbcTable {
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String FK_NAME = "FK_NAME";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final BLogger LOG = BLoggerFactory.getLogger(JdbcTable.class);
    private final String catalog;
    private final String schema;
    private final String name;
    private final String pkName;
    private final Map<String, JdbcColumn> columns = Maps.newHashMap();
    private final Map<String, JdbcForeignKey> foreignKeys = Maps.newHashMap();
    private final Map<String, JdbcIndex> indexes = Maps.newHashMap();
    private final Set<String> pkColumns = Sets.newHashSet();

    public JdbcTable(DatabaseMetaData dbMetadata, ResultSet metadata) throws SQLException {
        this.catalog = metadata.getString(TABLE_CAT);
        this.schema = metadata.getString(TABLE_SCHEM);
        this.name = metadata.getString(TABLE_NAME);
        this.pkName = this.readPrimaryKeyColumn(dbMetadata);
        this.readColumns(dbMetadata);
        this.readIndexes(dbMetadata);
        this.readForeignKeys(dbMetadata, metadata);
    }

    public JdbcColumn getColumn(String name) {
        return this.columns.get(name.toUpperCase());
    }

    public JdbcForeignKey getForeignKey(String name) {
        return this.foreignKeys.get(name.toUpperCase());
    }

    public Collection<JdbcForeignKey> getForeignKeys() {
        return this.foreignKeys.values();
    }

    public JdbcIndex getIndex(String name) {
        return this.indexes.get(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public String getPkName() {
        return this.pkName;
    }

    public String getSchema() {
        return this.schema;
    }

    public void logNotNullExtraColumns(Collection<String> columns) {
        HashSet nonNullColumns = Sets.newHashSet();
        HashSet columns2 = Sets.newHashSet();
        for (String columnName : columns) {
            columns2.add(columnName.toUpperCase());
        }
        for (JdbcColumn column : this.columns.values()) {
            if (column.isNullable() || columns2.contains(column.getName().toUpperCase())) continue;
            nonNullColumns.add(column.getName());
        }
        if (!nonNullColumns.isEmpty()) {
            LOG.warn("Table {0} has non null columns that are not referenced by the persistence unit {1}", this.name, nonNullColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readColumns(DatabaseMetaData dbMetadata) throws SQLException {
        ResultSet rs = null;
        try {
            rs = dbMetadata.getColumns(this.catalog, this.schema, this.name, "%");
            while (rs.next()) {
                JdbcColumn jdbcColumn = new JdbcColumn(rs);
                this.columns.put(jdbcColumn.getName().toUpperCase(), jdbcColumn);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readForeignKeys(DatabaseMetaData dbMetadata, ResultSet metadata) throws SQLException {
        ResultSet rs = null;
        try {
            rs = dbMetadata.getImportedKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                String name = rs.getString(FK_NAME);
                JdbcForeignKey foreignKey = this.getForeignKey(name);
                if (foreignKey == null) {
                    foreignKey = new JdbcForeignKey(rs);
                    this.foreignKeys.put(rs.getString(FK_NAME).toUpperCase(), foreignKey);
                }
                foreignKey.addColumn(rs);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexes(DatabaseMetaData dbMetadata) throws SQLException {
        ResultSet rs = null;
        try {
            rs = dbMetadata.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (rs.next()) {
                String name = rs.getString(INDEX_NAME);
                if (name == null) continue;
                JdbcIndex index = this.getIndex(name);
                if (index == null) {
                    index = new JdbcIndex(name);
                    this.indexes.put(name.toUpperCase(), index);
                }
                index.addColumn(rs.getString(COLUMN_NAME));
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPrimaryKeyColumn(DatabaseMetaData dbMetadata) throws SQLException {
        String pkName = null;
        ResultSet rs = null;
        try {
            rs = dbMetadata.getPrimaryKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                pkName = rs.getString("PK_NAME");
                this.pkColumns.add(rs.getString(COLUMN_NAME).toUpperCase());
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        return pkName;
    }

    public boolean requiresPkDrop(Set<String> pkColumnNames) {
        if (this.pkColumns.isEmpty()) {
            return false;
        }
        HashSet pkColumnNames2 = Sets.newHashSet();
        for (String columnName : pkColumnNames) {
            pkColumnNames2.add(columnName.toUpperCase());
        }
        return !pkColumnNames2.equals(this.pkColumns);
    }
}

