/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import javax.validation.Validation;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.PersistenceUnitInfoImpl;
import org.batoo.jpa.parser.impl.OrmParser;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;

public class PersistenceParserImpl
implements PersistenceParser {
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String ORM_XML = "META-INF/orm.xml";
    private static final BLogger LOG = BLoggerFactory.getLogger(PersistenceParserImpl.class);
    private final PersistenceUnitInfo puInfo;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final String provider;
    private final MetadataImpl metadata;
    private final List<String> ormMappingFiles;
    private final boolean hasValidators;

    public PersistenceParserImpl(PersistenceUnitInfo puInfo, Map<String, Object> properties) {
        this.puInfo = puInfo;
        this.provider = null;
        if (puInfo.getProperties() != null) {
            for (Map.Entry<Object, Object> entry : puInfo.getProperties().entrySet()) {
                this.properties.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.properties.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.hasValidators = this.createHasValidators(puInfo);
        this.metadata = new MetadataImpl();
        this.ormMappingFiles = puInfo.getMappingFileNames();
        this.parseOrmXmls();
        this.metadata.parse(puInfo);
    }

    public PersistenceParserImpl(String puName, Map<String, Object> properties) {
        this(new PersistenceUnitInfoImpl(puName), properties);
    }

    private boolean createHasValidators(PersistenceUnitInfo puInfo) {
        switch (puInfo.getValidationMode()) {
            case CALLBACK: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        try {
            Validation.buildDefaultValidatorFactory();
            return true;
        }
        catch (Exception e) {
            LOG.debug(e, "Validation cannot be enabled");
            LOG.warn("Validation mode is set to AUTO, yet no validation implementation seems to be available!\n\tValidation is being turned off.\n\tTo avoid this warning set validation-mode in your persistence.xml to NONE.\n\tExtra information can be obtained by turning debug log on...");
            return false;
        }
    }

    @Override
    public ClassLoader getClassloader() {
        return this.puInfo.getClassLoader();
    }

    @Override
    public DataSource getJtaDataSource() {
        return this.puInfo.getJtaDataSource();
    }

    @Override
    public MetadataImpl getMetadata() {
        return this.metadata;
    }

    @Override
    public DataSource getNonJtaDataSource() {
        return this.puInfo.getNonJtaDataSource();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.puInfo.getSharedCacheMode();
    }

    @Override
    public boolean hasValidators() {
        return this.hasValidators;
    }

    private void parseOrmXml(String mappingFile, boolean optional) {
        InputStream is = this.puInfo.getClassLoader().getResourceAsStream(mappingFile);
        if (is != null) {
            OrmParser ormParser = new OrmParser(mappingFile);
            ormParser.consume(is);
            this.metadata.merge(ormParser.getMetadata());
            LOG.debug("Merged ORM Metamodel {0}", this.metadata);
        } else if (!optional) {
            LOG.error("ORM Mapping file {0} could not be found!", mappingFile);
        }
    }

    private void parseOrmXmls() {
        if (this.ormMappingFiles.size() > 0) {
            for (String mappingFile : this.ormMappingFiles) {
                this.parseOrmXml(mappingFile, false);
            }
        } else {
            this.parseOrmXml(ORM_XML, true);
        }
    }
}

