/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.acl;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.impl.acl.BaseAnnotatedClassLocator;

public class JarAnnotatedClassLocator
extends BaseAnnotatedClassLocator {
    private static final BLogger LOG = BLoggerFactory.getLogger(JarAnnotatedClassLocator.class);
    private static final JarAnnotatedClassLocator INSTANCE = new JarAnnotatedClassLocator();

    public static JarAnnotatedClassLocator getInstance() {
        return INSTANCE;
    }

    private JarAnnotatedClassLocator() {
    }

    private Set<Class<?>> findClasses(PersistenceUnitInfo persistenceUnitInfo, URL url, Set<Class<?>> classes) throws IOException {
        JarFile jarFile = new JarFile(url.getFile());
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            Class<?> clazz;
            String className;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(className = entry.getName().replace('/', '.').replace('\\', '.')).endsWith(".class") || (clazz = this.isPersistentClass(persistenceUnitInfo.getClassLoader(), className.substring(0, className.length() - 6))) == null) continue;
            LOG.info("Found annotated class {0}", className);
            classes.add(clazz);
        }
        return classes;
    }

    @Override
    public Set<Class<?>> locateClasses(PersistenceUnitInfo persistenceUnitInfo, URL url) {
        Set<Class<?>> set;
        HashSet classes = Sets.newHashSet();
        try {
            LOG.info("Checking persistence root {0} for persistence classes...", url.getFile());
            set = this.findClasses(persistenceUnitInfo, url, classes);
        }
        catch (IOException e) {
            try {
                throw new PersistenceException("Unable to read JAR url: " + url);
            }
            catch (Throwable throwable) {
                LOG.info("Found persistent classes {0}", ((Object)classes).toString());
                throw throwable;
            }
        }
        LOG.info("Found persistent classes {0}", ((Object)classes).toString());
        return set;
    }
}

