/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public class NamedQueryMetadataImpl
implements NamedQueryMetadata {
    private final AbstractLocator locator;
    private final String query;
    private final String name;
    private final Map<String, Object> hints = Maps.newHashMap();
    private final LockModeType lockMode;

    public NamedQueryMetadataImpl(AbstractLocator locator, NamedQuery annotation) {
        this.locator = locator;
        this.name = annotation.name();
        this.query = annotation.query();
        this.lockMode = annotation.lockMode();
        for (QueryHint hint : annotation.hints()) {
            this.hints.put(hint.name(), hint.value());
        }
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public LockModeType getLockMode() {
        return this.lockMode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuery() {
        return this.query;
    }
}

