/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.common.log.ToStringBuilder;
import org.batoo.common.reflect.PropertyDescriptor;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.attribute.BasicAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.ElementCollectionAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.EmbeddedAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.EmbeddedIdAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.IdAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.ManyToManyAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.ManyToOneAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.OneToManyAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.OneToOneAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.TransientAttributeMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.VersionAttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.attribute.AttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.AttributesMetadata;
import org.batoo.jpa.parser.metadata.attribute.BasicAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ElementCollectionAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedIdAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.IdAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ManyToManyAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.ManyToOneAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToManyAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToOneAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.TransientAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.VersionAttributeMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;

public class AttributesMetadataImpl
implements AttributesMetadata {
    private static final BLogger LOG = BLoggerFactory.getLogger(AttributesMetadataImpl.class);
    private final ManagedTypeMetadata parent;
    private final AttributesMetadata metadata;
    private final List<TransientAttributeMetadata> transients;
    private final List<IdAttributeMetadata> ids;
    private final List<EmbeddedIdAttributeMetadata> embeddedIds;
    private final List<BasicAttributeMetadata> basics;
    private final List<VersionAttributeMetadata> versions;
    private final List<EmbeddedAttributeMetadata> embeddeds;
    private final List<ElementCollectionAttributeMetadata> elementCollections;
    private final List<OneToOneAttributeMetadata> oneToOnes;
    private final List<OneToManyAttributeMetadata> oneToManies;
    private final List<ManyToOneAttributeMetadata> manyToOnes;
    private final List<ManyToManyAttributeMetadata> manyToManies;
    private final Map<String, AttributeMetadata> ormAttributeMap = Maps.newHashMap();
    private final Map<String, Member> memberMap = Maps.newHashMap();

    public AttributesMetadataImpl(ManagedTypeMetadata parent, Class<?> clazz, AttributesMetadata metadata) {
        this.parent = parent;
        this.metadata = metadata;
        this.consolidateAttributes();
        this.probeAttributes(clazz);
        this.transients = this.handleTransients();
        this.versions = this.handleVersions();
        this.ids = this.handleIds();
        this.embeddedIds = this.handleEmbeddedIds();
        this.embeddeds = this.handleEmbeddeds();
        this.elementCollections = this.handleElementCollections();
        this.oneToOnes = this.handleOneToOnes();
        this.manyToOnes = this.handleManyToOnes();
        this.oneToManies = this.handleOneToManies();
        this.manyToManies = this.handleManyToManies();
        this.basics = this.handleBasics();
    }

    private void consolidateAttributes() {
        if (this.metadata != null) {
            LOG.debug("Consolidating ORM Attributes of entity {0}", this.parent.getClassName());
            this.consolidateAttributes(this.metadata.getBasics());
            this.consolidateAttributes(this.metadata.getEmbeddedIds());
            this.consolidateAttributes(this.metadata.getEmbeddeds());
            this.consolidateAttributes(this.metadata.getIds());
            this.consolidateAttributes(this.metadata.getManyToManies());
            this.consolidateAttributes(this.metadata.getManyToOnes());
            this.consolidateAttributes(this.metadata.getOneToManies());
            this.consolidateAttributes(this.metadata.getOneToOnes());
            this.consolidateAttributes(this.metadata.getTransients());
            this.consolidateAttributes(this.metadata.getVersions());
            LOG.debug("{0} ORM Attribute(s) obtained for entity {1}", this.ormAttributeMap.size(), this.parent.getClassName());
        }
    }

    private void consolidateAttributes(List<? extends AttributeMetadata> attributes) {
        for (AttributeMetadata attributeMetadata : attributes) {
            AttributeMetadata existing = this.ormAttributeMap.get(attributeMetadata.getName());
            if (existing != null) {
                throw new MappingException("Duplicate attribute names.", existing.getLocator(), attributeMetadata.getLocator());
            }
            this.ormAttributeMap.put(attributeMetadata.getName(), attributeMetadata);
        }
    }

    @Override
    public List<BasicAttributeMetadata> getBasics() {
        return this.basics;
    }

    @Override
    public List<ElementCollectionAttributeMetadata> getElementCollections() {
        return this.elementCollections;
    }

    @Override
    public List<EmbeddedIdAttributeMetadata> getEmbeddedIds() {
        return this.embeddedIds;
    }

    @Override
    public List<EmbeddedAttributeMetadata> getEmbeddeds() {
        return this.embeddeds;
    }

    @Override
    public List<IdAttributeMetadata> getIds() {
        return this.ids;
    }

    @Override
    public List<ManyToManyAttributeMetadata> getManyToManies() {
        return this.manyToManies;
    }

    @Override
    public List<ManyToOneAttributeMetadata> getManyToOnes() {
        return this.manyToOnes;
    }

    @Override
    public List<OneToManyAttributeMetadata> getOneToManies() {
        return this.oneToManies;
    }

    @Override
    public List<OneToOneAttributeMetadata> getOneToOnes() {
        return this.oneToOnes;
    }

    @Override
    public List<TransientAttributeMetadata> getTransients() {
        return this.transients;
    }

    @Override
    public List<VersionAttributeMetadata> getVersions() {
        return this.versions;
    }

    private List<BasicAttributeMetadata> handleBasics() {
        List<BasicAttributeMetadata> list = this.metadata != null ? this.metadata.getBasics() : null;
        return new AttributesParser<BasicAttributeMetadata>(this.memberMap, list, null){

            @Override
            protected BasicAttributeMetadata parseAttribute(String name, Member member, BasicAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new BasicAttributeMetadataImpl(member, metadata);
                }
                return new BasicAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private List<ElementCollectionAttributeMetadata> handleElementCollections() {
        List<ElementCollectionAttributeMetadata> list = this.metadata != null ? this.metadata.getElementCollections() : null;
        return new AttributesParser<ElementCollectionAttributeMetadata>(this.memberMap, list, ElementCollection.class){

            @Override
            protected ElementCollectionAttributeMetadata parseAttribute(String name, Member member, ElementCollectionAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new ElementCollectionAttributeMetadataImpl(member, metadata);
                }
                ElementCollection elementCollection = ReflectHelper.getAnnotation(member, ElementCollection.class);
                return new ElementCollectionAttributeMetadataImpl(member, name, elementCollection, parsed);
            }
        };
    }

    private List<EmbeddedIdAttributeMetadata> handleEmbeddedIds() {
        List<EmbeddedIdAttributeMetadata> list = this.metadata != null ? this.metadata.getEmbeddedIds() : null;
        return new AttributesParser<EmbeddedIdAttributeMetadata>(this.memberMap, list, EmbeddedId.class){

            @Override
            protected EmbeddedIdAttributeMetadata parseAttribute(String name, Member member, EmbeddedIdAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new EmbeddedIdAttributeMetadataImpl(member, metadata);
                }
                return new EmbeddedIdAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private List<EmbeddedAttributeMetadata> handleEmbeddeds() {
        List<EmbeddedAttributeMetadata> list = this.metadata != null ? this.metadata.getEmbeddeds() : null;
        return new AttributesParser<EmbeddedAttributeMetadata>(this.memberMap, list, Embedded.class){

            @Override
            protected EmbeddedAttributeMetadata parseAttribute(String name, Member member, EmbeddedAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new EmbeddedAttributeMetadataImpl(member, metadata);
                }
                return new EmbeddedAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private List<IdAttributeMetadata> handleIds() {
        List<IdAttributeMetadata> list = this.metadata != null ? this.metadata.getIds() : null;
        return new AttributesParser<IdAttributeMetadata>(this.memberMap, list, Id.class){

            @Override
            protected IdAttributeMetadata parseAttribute(String name, Member member, IdAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new IdAttributeMetadataImpl(member, metadata);
                }
                return new IdAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private List<ManyToManyAttributeMetadata> handleManyToManies() {
        List<ManyToManyAttributeMetadata> list = this.metadata != null ? this.metadata.getManyToManies() : null;
        return new AttributesParser<ManyToManyAttributeMetadata>(this.memberMap, list, ManyToMany.class){

            @Override
            protected ManyToManyAttributeMetadata parseAttribute(String name, Member member, ManyToManyAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new ManyToManyAttributeMetadataImpl(member, metadata);
                }
                ManyToMany manyToMany = ReflectHelper.getAnnotation(member, ManyToMany.class);
                return new ManyToManyAttributeMetadataImpl(member, name, manyToMany, parsed);
            }
        };
    }

    private List<ManyToOneAttributeMetadata> handleManyToOnes() {
        List<ManyToOneAttributeMetadata> list = this.metadata != null ? this.metadata.getManyToOnes() : null;
        return new AttributesParser<ManyToOneAttributeMetadata>(this.memberMap, list, ManyToOne.class){

            @Override
            protected ManyToOneAttributeMetadata parseAttribute(String name, Member member, ManyToOneAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new ManyToOneAttributeMetadataImpl(member, metadata);
                }
                ManyToOne manyToOne = ReflectHelper.getAnnotation(member, ManyToOne.class);
                return new ManyToOneAttributeMetadataImpl(member, name, manyToOne, parsed);
            }
        };
    }

    private List<OneToManyAttributeMetadata> handleOneToManies() {
        List<OneToManyAttributeMetadata> list = this.metadata != null ? this.metadata.getOneToManies() : null;
        return new AttributesParser<OneToManyAttributeMetadata>(this.memberMap, list, OneToMany.class){

            @Override
            protected OneToManyAttributeMetadata parseAttribute(String name, Member member, OneToManyAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new OneToManyAttributeMetadataImpl(member, metadata);
                }
                OneToMany oneToMany = ReflectHelper.getAnnotation(member, OneToMany.class);
                return new OneToManyAttributeMetadataImpl(member, name, oneToMany, parsed);
            }
        };
    }

    private List<OneToOneAttributeMetadata> handleOneToOnes() {
        List<OneToOneAttributeMetadata> list = this.metadata != null ? this.metadata.getOneToOnes() : null;
        return new AttributesParser<OneToOneAttributeMetadata>(this.memberMap, list, OneToOne.class){

            @Override
            protected OneToOneAttributeMetadata parseAttribute(String name, Member member, OneToOneAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new OneToOneAttributeMetadataImpl(member, metadata);
                }
                OneToOne oneToOne = ReflectHelper.getAnnotation(member, OneToOne.class);
                return new OneToOneAttributeMetadataImpl(member, name, oneToOne, parsed);
            }
        };
    }

    private List<TransientAttributeMetadata> handleTransients() {
        List<TransientAttributeMetadata> list = this.metadata != null ? this.metadata.getTransients() : null;
        return new AttributesParser<TransientAttributeMetadata>(this.memberMap, list, Transient.class){

            @Override
            protected TransientAttributeMetadata parseAttribute(String name, Member member, TransientAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new TransientAttributeMetadataImpl(member, metadata);
                }
                return new TransientAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private List<VersionAttributeMetadata> handleVersions() {
        List<VersionAttributeMetadata> list = this.metadata != null ? this.metadata.getVersions() : null;
        return new AttributesParser<VersionAttributeMetadata>(this.memberMap, list, Version.class){

            @Override
            protected VersionAttributeMetadata parseAttribute(String name, Member member, VersionAttributeMetadata metadata, Set<Class<? extends Annotation>> parsed) {
                if (metadata != null) {
                    return new VersionAttributeMetadataImpl(member, metadata);
                }
                return new VersionAttributeMetadataImpl(member, name, parsed);
            }
        };
    }

    private boolean isApplicableToAccessType(Member member, AttributeMetadata ormMetadata) {
        AccessType effective;
        if (this.parent.isMetadataComplete() && ormMetadata == null) {
            return false;
        }
        if (ormMetadata != null && ormMetadata.getAccess() != null) {
            effective = ormMetadata.getAccess();
        } else {
            Access access = ReflectHelper.getAnnotation(member, Access.class);
            if (access != null) {
                if (access.value() == null) {
                    effective = member instanceof Field ? AccessType.FIELD : AccessType.PROPERTY;
                } else {
                    effective = access.value();
                    if (member instanceof Field && effective == AccessType.PROPERTY) {
                        throw new MappingException("Illegal @Access(AccessType.PROPERTY) on field " + member, new AbstractLocator[0]);
                    }
                    if (member instanceof Method && effective == AccessType.FIELD) {
                        throw new MappingException("Illegal @Access(AccessType.FIELD) on property " + member, new AbstractLocator[0]);
                    }
                }
            } else {
                effective = this.parent.getAccessType();
            }
        }
        switch (effective) {
            case FIELD: {
                return member instanceof Field;
            }
        }
        return member instanceof Method;
    }

    public boolean isMetadataComplete() {
        return this.parent.isMetadataComplete();
    }

    private void probeAttributes(Class<?> clazz) {
        AccessType accessType = this.parent.getAccessType();
        switch (accessType) {
            case FIELD: {
                this.probeFields(clazz, accessType);
                this.probeProperties(clazz, accessType);
                break;
            }
            case PROPERTY: {
                this.probeProperties(clazz, accessType);
                this.probeFields(clazz, accessType);
            }
        }
    }

    private void probeFields(Class<?> clazz, AccessType accessType) {
        for (Field field : clazz.getDeclaredFields()) {
            AttributeMetadata ormMetadata;
            boolean applicable;
            String name = field.getName();
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !(applicable = this.isApplicableToAccessType(field, ormMetadata = this.ormAttributeMap.get(name)))) continue;
            this.memberMap.put(name, field);
        }
    }

    private void probeProperties(Class<?> clazz, AccessType accessType) {
        PropertyDescriptor[] properties;
        for (PropertyDescriptor property : properties = ReflectHelper.getProperties(clazz)) {
            String name;
            AttributeMetadata ormMetadata;
            Method method = property.getReader();
            boolean applicable = this.isApplicableToAccessType(method, ormMetadata = this.ormAttributeMap.get(name = property.getName()));
            if (!applicable) continue;
            this.memberMap.put(name, method);
        }
    }

    public String toString() {
        return new ToStringBuilder(this).excludeFieldNames("parent", "ormMetadata", "ormAttributeMap", "memberMap").toString();
    }

    private abstract class AttributesParser<A extends AttributeMetadata>
    extends ArrayList<A> {
        private final Map<String, Member> memberMap;
        private final List<A> metadatas;
        private final Class<? extends Annotation> indicativeAnnotation;

        public AttributesParser(Map<String, Member> memberMap, List<A> metadatas, Class<? extends Annotation> indicativeAnnotation) {
            this.memberMap = memberMap;
            this.metadatas = metadatas != null ? metadatas : Lists.newArrayList();
            this.indicativeAnnotation = indicativeAnnotation;
            this.probe();
            this.metadatas.removeAll(this);
            if (this.metadatas.size() > 0) {
                throw new MappingException("The following attributes defined in orm.xml could be located\n" + metadatas, new AbstractLocator[0]);
            }
        }

        protected abstract A parseAttribute(String var1, Member var2, A var3, Set<Class<? extends Annotation>> var4);

        private void probe() {
            HashSet parsed = Sets.newHashSet();
            if (this.metadatas != null) {
                for (AttributeMetadata attribute : this.metadatas) {
                    Member member = this.memberMap.remove(attribute.getName());
                    if (member == null) {
                        throw new MappingException("The attribute " + attribute.getName() + " cannot be found.", attribute.getLocator());
                    }
                    this.add(this.parseAttribute(attribute.getName(), member, attribute, parsed));
                    ReflectHelper.warnAnnotations(LOG, member, parsed);
                }
            }
            if (!AttributesMetadataImpl.this.isMetadataComplete()) {
                Iterator<Map.Entry<String, Member>> i = this.memberMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, Member> entry = i.next();
                    String name = entry.getKey();
                    Member member = entry.getValue();
                    if (this.indicativeAnnotation != null && ReflectHelper.getAnnotation(member, this.indicativeAnnotation) == null || this.indicativeAnnotation == Id.class && (ReflectHelper.getAnnotation(member, ManyToOne.class) != null || ReflectHelper.getAnnotation(member, OneToOne.class) != null)) continue;
                    i.remove();
                    this.add(this.parseAttribute(name, member, null, parsed));
                    ReflectHelper.warnAnnotations(LOG, member, parsed);
                }
            }
        }
    }
}

