/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.annotations.ColumnTransformer;
import org.batoo.jpa.annotations.Index;
import org.batoo.jpa.parser.impl.metadata.ColumnTransformerMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.IndexMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.PhysicalAttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.attribute.BasicAttributeMetadata;

public class BasicAttributeMetadataImpl
extends PhysicalAttributeMetadataImpl
implements BasicAttributeMetadata {
    private final boolean lob;
    private final EnumType enumType;
    private final boolean optional;
    private final FetchType fetchType;
    private final IndexMetadata index;
    private final ColumnTransformerMetadata columnTransformer;

    public BasicAttributeMetadataImpl(Member member, BasicAttributeMetadata metadata) {
        super(member, metadata);
        this.lob = metadata.isLob();
        this.enumType = metadata.getEnumType();
        this.optional = metadata.isOptional();
        this.fetchType = metadata.getFetchType();
        this.index = metadata.getIndex();
        this.columnTransformer = metadata.getColumnTransformer();
    }

    public BasicAttributeMetadataImpl(Member member, String name, Set<Class<? extends Annotation>> parsed) {
        super(member, name, parsed);
        Basic basic = ReflectHelper.getAnnotation(member, Basic.class);
        Lob lob = ReflectHelper.getAnnotation(member, Lob.class);
        Enumerated enumerated = ReflectHelper.getAnnotation(member, Enumerated.class);
        Index index = ReflectHelper.getAnnotation(member, Index.class);
        ColumnTransformer columnTransformer = ReflectHelper.getAnnotation(member, ColumnTransformer.class);
        parsed.add(Lob.class);
        parsed.add(Basic.class);
        parsed.add(Enumerated.class);
        parsed.add(Basic.class);
        parsed.add(Index.class);
        parsed.add(ColumnTransformer.class);
        this.optional = basic != null ? basic.optional() : true;
        this.fetchType = basic != null ? basic.fetch() : FetchType.EAGER;
        this.lob = lob != null;
        this.enumType = enumerated != null ? enumerated.value() : null;
        this.index = index != null ? new IndexMetadataImpl(this.getLocator(), index, this.getName()) : null;
        this.columnTransformer = columnTransformer != null ? new ColumnTransformerMetadataImpl(this.getLocator(), columnTransformer) : null;
    }

    @Override
    public ColumnTransformerMetadata getColumnTransformer() {
        return this.columnTransformer;
    }

    @Override
    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public IndexMetadata getIndex() {
        return this.index;
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

