/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.common.impl.log;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class BLoggerImpl
implements BLogger {
    private static final String FATAL_PREFIX = "FATAL----> ";
    private static final Object[] NULL_ARRAY = new Object[0];
    private final Marker fatalMarker;
    private final Logger logger;

    public BLoggerImpl(Logger logger) {
        this.logger = logger;
        this.fatalMarker = MarkerFactory.getMarker((String)"FATAL");
    }

    @Override
    public Object boxed(String block) {
        return this.boxed(block, null);
    }

    @Override
    public String boxed(String block, Object[] parameters) {
        try {
            if (parameters != null && parameters.length > 0) {
                block = block + "\n\n" + Arrays.toString(parameters);
            }
            block = block.replaceAll("\\t", "    ");
            List lines = IOUtils.readLines((Reader)new StringReader(block));
            int max = 0;
            for (String line : lines) {
                max = Math.max(max, line.length());
            }
            StringBuffer boxed = new StringBuffer("\n");
            boxed.append(StringUtils.repeat((String)"-", (int)(max += 4)));
            boxed.append("\n");
            for (String line : lines) {
                boxed.append("| ");
                boxed.append(StringUtils.rightPad((String)line, (int)(max - 4)));
                boxed.append(" |\n");
            }
            boxed.append(StringUtils.repeat((String)"-", (int)max));
            return boxed.toString();
        }
        catch (Exception e) {
            return block;
        }
    }

    @Override
    public void debug(String message) {
        this.debug(null, message, NULL_ARRAY);
    }

    @Override
    public void debug(String message, Object ... params) {
        this.debug(null, message, params);
    }

    @Override
    public void debug(Throwable t, String message) {
        this.debug(t, message, NULL_ARRAY);
    }

    @Override
    public void debug(Throwable t, String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            if (t != null) {
                this.logger.debug(this.format(message, params), t);
            } else {
                this.logger.debug(this.format(message, params));
            }
        }
    }

    @Override
    public void error(String message) {
        this.error(null, message, NULL_ARRAY);
    }

    @Override
    public void error(String message, Object ... params) {
        this.error(null, message, params);
    }

    @Override
    public void error(Throwable t, String message) {
        this.error(t, message, NULL_ARRAY);
    }

    @Override
    public void error(Throwable t, String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            if (t != null) {
                this.logger.error(this.format(message, params), t);
            } else {
                this.logger.error(this.format(message, params));
            }
        }
    }

    @Override
    public void fatal(String message) {
        this.trace(null, message, NULL_ARRAY);
    }

    @Override
    public void fatal(String message, Object ... params) {
        this.fatal(null, message, params);
    }

    @Override
    public void fatal(Throwable t, String message) {
        this.fatal(t, message, NULL_ARRAY);
    }

    @Override
    public void fatal(Throwable t, String message, Object ... params) {
        if (t != null) {
            this.logger.error(this.fatalMarker, FATAL_PREFIX + this.format(message, params), t);
        } else {
            this.logger.error(this.fatalMarker, FATAL_PREFIX + this.format(message, params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(ToStringBuilder.DetailLevel level, String message, Object ... params) {
        if (params == null || params.length == 0) {
            return message;
        }
        ToStringBuilder.setDetailLevel(level);
        try {
            String string = MessageFormat.format(message, params);
            return string;
        }
        finally {
            ToStringBuilder.setDetailLevel(null);
        }
    }

    private String format(String message, Object ... params) {
        return this.format(ToStringBuilder.DetailLevel.LONG, message, params);
    }

    @Override
    public void info(String message) {
        this.info(null, message, NULL_ARRAY);
    }

    @Override
    public void info(String message, Object ... params) {
        this.info(null, message, params);
    }

    @Override
    public void info(Throwable t, String message) {
        this.info(t, message, NULL_ARRAY);
    }

    @Override
    public void info(Throwable t, String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            if (t != null) {
                this.logger.info(this.format(message, params), t);
            } else {
                this.logger.info(this.format(message, params));
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public Object lazyBoxed(Object block) {
        return this.lazyBoxed(block, null);
    }

    @Override
    public Object lazyBoxed(final Object block, final Object[] parameters) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BLoggerImpl.this.boxed(block != null ? block.toString() : null, parameters);
            }

            public String toString() {
                try {
                    return this.call();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    @Override
    public void trace(String message) {
        this.trace(null, message, NULL_ARRAY);
    }

    @Override
    public void trace(String message, Object ... params) {
        this.trace(null, message, params);
    }

    @Override
    public void trace(Throwable t, String message) {
        this.trace(t, message, NULL_ARRAY);
    }

    @Override
    public void trace(Throwable t, String message, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            if (t != null) {
                this.logger.trace(this.format(message, params), t);
            } else {
                this.logger.trace(this.format(message, params));
            }
        }
    }

    @Override
    public void warn(String message) {
        this.warn(null, message, NULL_ARRAY);
    }

    @Override
    public void warn(String message, Object ... params) {
        this.warn(null, message, params);
    }

    @Override
    public void warn(Throwable t, String message) {
        this.warn(t, message, NULL_ARRAY);
    }

    @Override
    public void warn(Throwable t, String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            if (t != null) {
                this.logger.warn(this.format(message, params), t);
            } else {
                this.logger.warn(this.format(message, params));
            }
        }
    }
}

