/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.SharedCacheMode;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.cache.CacheInstance;
import org.batoo.jpa.core.impl.cache.CacheReference;
import org.batoo.jpa.core.impl.cache.CacheStats;
import org.batoo.jpa.core.impl.cache.ResultListReference;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class CacheImpl
implements Cache {
    private static final BLogger LOG = BLoggerFactory.getLogger(CacheImpl.class);
    private static final ThreadLocal<CacheRetrieveMode> cacheRetrieveMode = new ThreadLocal();
    private static final ThreadLocal<CacheStoreMode> cacheStoreMode = new ThreadLocal();
    private final EntityManagerFactoryImpl emf;
    private final SharedCacheMode cacheMode;
    private final boolean on;
    private final HashMap<Class<?>, Map<Object, CacheInstance>> cacheDelegate = Maps.newHashMap();
    private final HashMap<ResultListReference, List<CacheReference[]>> queryCacheDelegate = Maps.newHashMap();
    private final HashMap<Class<?>, CacheStats> statsDelegate = Maps.newHashMap();
    private CacheStats stats;

    public CacheImpl(EntityManagerFactoryImpl emf, SharedCacheMode cacheMode) {
        this.emf = emf;
        this.cacheMode = cacheMode;
        switch (this.cacheMode) {
            case ALL: 
            case DISABLE_SELECTIVE: 
            case ENABLE_SELECTIVE: {
                this.on = true;
                break;
            }
            default: {
                this.on = false;
            }
        }
        this.reset();
    }

    public boolean contains(Class<?> cls, Object primaryKey) {
        return this.getEntityMap(cls).containsKey(primaryKey);
    }

    public void evict(Class<?> clazz) {
        LOG.info("Clearing the entity cache completely for {0}...", clazz);
        this.getEntityMap(clazz).clear();
        this.statsDelegate.remove(clazz);
    }

    public void evict(Class<?> clazz, Object primaryKey) {
        this.getStats(clazz);
    }

    public void evictAll() {
        LOG.info("Clearing the cache completely...");
        this.cacheDelegate.clear();
        this.statsDelegate.clear();
        this.reset();
    }

    public CacheInstance get(ManagedId<?> id) {
        Class clazz = id.getType().getRootMapping().getJavaType();
        CacheInstance cacheInstance = this.getEntityMap(clazz).get(id.getId());
        if (cacheInstance != null) {
            this.stats.hit(id.getId());
            this.getStats(clazz).hit(id.getId());
        } else {
            this.stats.miss(id.getId());
            this.getStats(clazz).miss(id.getId());
        }
        return cacheInstance;
    }

    public List<CacheReference[]> get(String sql, Object[] parameters) {
        ResultListReference reference = new ResultListReference(sql, parameters);
        List<CacheReference[]> results = this.queryCacheDelegate.get(reference);
        if (results != null) {
            this.stats.qhit(sql);
        } else {
            this.stats.qmiss(sql);
        }
        return results;
    }

    public SharedCacheMode getCacheMode() {
        return this.cacheMode;
    }

    public CacheRetrieveMode getCacheRetrieveMode(EntityTypeImpl<?> type) {
        if (!this.on) {
            return CacheRetrieveMode.BYPASS;
        }
        CacheRetrieveMode mode = cacheRetrieveMode.get();
        return mode != null ? mode : (type.isCachable() ? CacheRetrieveMode.USE : CacheRetrieveMode.BYPASS);
    }

    public CacheStoreMode getCacheStoreMode(EntityTypeImpl<?> type) {
        if (!this.on) {
            return CacheStoreMode.BYPASS;
        }
        CacheStoreMode mode = cacheStoreMode.get();
        return mode != null ? mode : (type.isCachable() ? CacheStoreMode.USE : CacheStoreMode.BYPASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, CacheInstance> getEntityMap(Class<?> clazz) {
        HashMap entityMap = this.cacheDelegate.get(clazz);
        if (entityMap == null) {
            this.lockEntityMap(clazz);
            try {
                entityMap = this.cacheDelegate.get(clazz);
                if (entityMap == null) {
                    entityMap = Maps.newHashMap();
                    this.cacheDelegate.put(clazz, entityMap);
                }
            }
            finally {
                this.unlockEntityMap(clazz);
            }
        }
        return entityMap;
    }

    public CacheStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStats getStats(Class<?> clazz) {
        CacheStats cacheStats = this.statsDelegate.get(clazz);
        if (cacheStats == null) {
            CacheImpl cacheImpl = this;
            synchronized (cacheImpl) {
                cacheStats = this.statsDelegate.get(clazz);
                if (cacheStats == null) {
                    cacheStats = new CacheStats(clazz.getName());
                    this.statsDelegate.put(clazz, cacheStats);
                }
            }
        }
        return cacheStats;
    }

    public boolean isOn() {
        return this.on;
    }

    private void lockEntityMap(Class<?> clazz) {
    }

    public void put(ManagedInstance<?> instance) {
        Class clazz = instance.getType().getRootType().getJavaType();
        Object id = instance.getId().getId();
        if (instance.getStatus() == Status.REMOVED) {
            this.getEntityMap(clazz).remove(id);
            this.stats.evict(instance.getType().getJavaType() + ":" + id);
            this.getStats(clazz).evict(id);
        } else {
            this.getEntityMap(clazz).put(id, new CacheInstance(this, instance));
            this.stats.put(instance.getType().getJavaType() + ":" + id);
            this.getStats(clazz).put(id);
        }
    }

    public void put(String sql, Object[] parameters, List<?> results) {
        MetamodelImpl metamodel = this.emf.getMetamodel();
        ArrayList references = Lists.newArrayList();
        for (int i = 0; i < results.size(); ++i) {
            CacheReference[] referenceArray;
            Object result = results.get(i);
            if (result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                referenceArray = new CacheReference[resultArray.length];
                for (int j = 0; j < resultArray.length; ++j) {
                    referenceArray[j] = new CacheReference(metamodel, resultArray[j]);
                }
            } else {
                referenceArray = new CacheReference[]{new CacheReference(metamodel, result)};
            }
            references.add(referenceArray);
        }
        ResultListReference reference = new ResultListReference(sql, parameters);
        this.queryCacheDelegate.put(reference, references);
    }

    private void reset() {
        this.stats = new CacheStats("Global");
    }

    public void setCacheRetrieveMode(CacheRetrieveMode mode) {
        if (!this.on) {
            LOG.warn("Ignoring cache mode hint as the shared cache is disabled: {0}", mode);
            return;
        }
        cacheRetrieveMode.set(mode);
    }

    public void setCacheStoreMode(CacheStoreMode mode) {
        if (!this.on) {
            LOG.warn("Ignoring cache mode hint as the shared cache is disabled: {0}", mode);
            return;
        }
        cacheStoreMode.set(mode);
    }

    private void unlockEntityMap(Class<?> clazz) {
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }
}

