/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.util.BatooUtils;

public abstract class ManagedCollection<E>
implements Serializable {
    private transient boolean changed;
    private final transient ManagedInstance<?> managedInstance;
    private final transient PluralMapping<?, ?, E> mapping;
    private transient AssociationMapping<?, ?, ?> inverse;
    private final transient int insertBatchSize;

    public ManagedCollection() {
        this.mapping = null;
        this.managedInstance = null;
        this.inverse = null;
        this.changed = false;
        this.insertBatchSize = this.managedInstance.getSession().getEntityManager().getJdbcAdaptor().getInsertBatchSize();
    }

    public ManagedCollection(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance) {
        this.mapping = mapping;
        this.managedInstance = managedInstance;
        this.insertBatchSize = this.managedInstance.getSession().getEntityManager().getJdbcAdaptor().getInsertBatchSize();
        if (mapping instanceof PluralAssociationMapping) {
            this.inverse = ((PluralAssociationMapping)mapping).getInverse();
        }
    }

    public abstract boolean addChild(EntryImpl<Object, ManagedInstance<?>> var1);

    public abstract boolean addElement(EntryImpl<Object, ?> var1);

    protected final void changed() {
        if (!this.changed && this.managedInstance != null) {
            this.changed = true;
            this.managedInstance.setChanged(this.mapping);
        }
    }

    public abstract void flush(Connection var1, boolean var2, boolean var3) throws SQLException;

    public abstract Collection<E> getDelegate();

    protected int getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public ManagedInstance<?> getManagedInstance() {
        return this.managedInstance;
    }

    protected PluralMapping<?, ?, E> getMapping() {
        return this.mapping;
    }

    protected abstract Collection<E> getSnapshot();

    public abstract void initialize();

    public abstract boolean isInitialized();

    public void mergeWith(EntityManagerImpl entityManager, Object instance, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed) {
        ArrayList mergedChildren = Lists.newArrayList();
        Object children = this.mapping.get(instance);
        if (children instanceof ManagedCollection && !((ManagedCollection)children).isInitialized()) {
            return;
        }
        Collection collection = children instanceof Collection ? (Collection)children : ((Map)children).values();
        for (Object child : collection) {
            mergedChildren.add(entityManager.mergeImpl(child, requiresFlush, processed, this.mapping.cascadesMerge()));
        }
        this.snapshot();
        Collection<E> delegate = this.getDelegate();
        boolean changed = false;
        SessionImpl session = entityManager.getSession();
        PluralAssociationMapping inversePluralMapping = this.inverse != null && this.inverse.getAttribute() instanceof PluralAttributeImpl ? (PluralAssociationMapping)this.inverse : null;
        for (int i = 0; i < mergedChildren.size(); ++i) {
            Object child = mergedChildren.get(i);
            if (delegate.contains(child)) continue;
            this.getDelegate().add(child);
            if (this.inverse != null) {
                if (inversePluralMapping != null) {
                    Collection inverseCollection = (Collection)inversePluralMapping.get(child);
                    if (!inverseCollection.contains(this.managedInstance.getInstance())) {
                        inverseCollection.add(this.managedInstance.getInstance());
                    }
                } else {
                    this.inverse.set(session.get(child).getInstance(), this.managedInstance.getInstance());
                }
            }
            changed = true;
        }
        ArrayList delegateList = Lists.newArrayList(delegate);
        for (int i = 0; i < delegateList.size(); ++i) {
            Object child = delegateList.get(i);
            if (mergedChildren.contains(child)) continue;
            this.removeChild(child);
            if (this.inverse != null) {
                if (inversePluralMapping != null) {
                    Collection inverseCollection = (Collection)inversePluralMapping.get(child);
                    inverseCollection.remove(this.managedInstance.getInstance());
                } else {
                    this.inverse.set(session.get(child).getInstance(), null);
                }
            }
            changed = true;
        }
        if (changed) {
            this.changed();
        }
    }

    public void persistAdditions(EntityManagerImpl entityManager) {
        List<E> added = BatooUtils.subtract(this.getDelegate(), this.getSnapshot());
        for (Object e : added) {
            entityManager.persistImpl(e, Lists.newArrayList());
        }
    }

    public abstract void refreshChildren();

    protected abstract void removeChild(E var1);

    protected boolean removed(Connection connection, boolean removals) throws SQLException {
        if (removals && this.managedInstance.getStatus() == Status.REMOVED) {
            this.mapping.detachAll(connection, this.managedInstance);
            return true;
        }
        return false;
    }

    public void removeOrphans(EntityManagerImpl entityManager) {
        List<E> removed = BatooUtils.subtract(this.getSnapshot(), this.getDelegate());
        for (int i = 0; i < removed.size(); ++i) {
            entityManager.remove(removed.get(i));
        }
    }

    protected void reset() {
        this.changed = false;
    }

    protected abstract void snapshot();
}

