/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.ObjectUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.WrappedIterator;
import org.batoo.jpa.core.impl.collections.WrappedListIterator;
import org.batoo.jpa.core.impl.criteria.EntryImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.Joinable;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.util.BatooUtils;

public class ManagedList<X, E>
extends ManagedCollection<E>
implements List<E> {
    private ArrayList<E> delegate;
    private transient ArrayList<E> snapshot;
    private boolean initialized;

    public ManagedList() {
    }

    public ManagedList(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance, boolean lazy) {
        super(mapping, managedInstance);
        this.delegate = Lists.newArrayList();
        this.initialized = !lazy;
    }

    public ManagedList(PluralMapping<?, ?, E> mapping, ManagedInstance<?> managedInstance, Collection<? extends E> values) {
        super(mapping, managedInstance);
        this.delegate = Lists.newArrayList();
        HashSet uniqueSet = Sets.newHashSet();
        if (values instanceof List) {
            List valuesList = (List)values;
            for (int i = 0; i < valuesList.size(); ++i) {
                Object child = valuesList.get(i);
                if (child == null) {
                    throw new NullPointerException("Instance " + this.getManagedInstance() + " has null items in its collection " + this.getMapping().getPath());
                }
                this.delegate.add(child);
                uniqueSet.add(child);
            }
        } else {
            for (E child : values) {
                if (child == null) {
                    throw new NullPointerException("Instance " + this.getManagedInstance() + " has null items in its collection " + this.getMapping().getPath());
                }
                this.delegate.add(child);
                uniqueSet.add(child);
            }
        }
        if (uniqueSet.size() != this.delegate.size()) {
            throw this.noDuplicates();
        }
        this.initialized = true;
    }

    @Override
    public boolean add(E e) {
        this.snapshot();
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.delegate.contains(e)) {
            throw this.noDuplicates();
        }
        this.delegate.add(e);
        this.changed();
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.snapshot();
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.contains(element)) {
            throw this.noDuplicates();
        }
        this.delegate.add(index, element);
        this.changed();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.snapshot();
        if (c instanceof List) {
            List list = (List)c;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.delegate.contains(list.get(i))) continue;
                throw this.noDuplicates();
            }
        } else {
            for (E e : c) {
                if (!this.delegate.contains(e)) continue;
                throw this.noDuplicates();
            }
        }
        if (this.delegate.addAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.snapshot();
        if (c instanceof List) {
            List list = (List)c;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.delegate.contains(list.get(i))) continue;
                throw this.noDuplicates();
            }
        } else {
            for (E e : c) {
                if (!this.delegate.contains(e)) continue;
                throw this.noDuplicates();
            }
        }
        if (this.delegate.addAll(index, c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean addChild(EntryImpl<Object, ManagedInstance<?>> child) {
        Object e = child.getValue().getInstance();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    @Override
    public boolean addElement(EntryImpl<Object, ?> child) {
        Object e = child.getValue();
        if (!this.delegate.contains(e)) {
            return this.delegate.add(e);
        }
        return false;
    }

    private void attachChildren(Connection connection, ManagedInstance<?> instance, PluralMapping<?, ?, E> mapping) throws SQLException {
        int insertBatchSize = this.getInsertBatchSize();
        Joinable[] batch = new Joinable[insertBatchSize];
        int i = 0;
        while (i < this.delegate.size()) {
            int batchSize;
            for (batchSize = 0; i < this.delegate.size() && batchSize < insertBatchSize; ++batchSize, ++i) {
                E child = this.delegate.get(i);
                batch[batchSize] = new Joinable(null, child, i);
            }
            if (batchSize <= 0) continue;
            mapping.attach(connection, instance, batch, batchSize);
        }
    }

    @Override
    public void clear() {
        this.snapshot();
        if (this.delegate.size() > 0) {
            this.changed();
        }
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.initialize();
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.initialize();
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        this.initialize();
        return this.delegate.equals(obj);
    }

    @Override
    public void flush(Connection connection, boolean removals, boolean force) throws SQLException {
        if (this.removed(connection, removals)) {
            return;
        }
        ManagedInstance<?> instance = this.getManagedInstance();
        PluralMapping mapping = this.getMapping();
        if (force) {
            this.attachChildren(connection, instance, mapping);
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        if (removals) {
            mapping.detachAll(connection, instance);
        } else {
            this.attachChildren(connection, instance, mapping);
        }
    }

    @Override
    public E get(int index) {
        this.initialize();
        return this.delegate.get(index);
    }

    @Override
    public ArrayList<E> getDelegate() {
        return this.delegate;
    }

    @Override
    protected Collection<E> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int hashCode() {
        this.initialize();
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        this.initialize();
        return this.delegate.indexOf(o);
    }

    @Override
    public void initialize() {
        if (!this.initialized) {
            ManagedInstance<?> managedInstance = this.getManagedInstance();
            if (managedInstance == null) {
                throw new PersistenceException("No session to initialize the collection");
            }
            PluralMapping mapping = this.getMapping();
            if (!(mapping instanceof PluralAssociationMapping) || !managedInstance.tryLoadFromCache((PluralAssociationMapping)mapping)) {
                BatooUtils.addAll(mapping.loadCollection(managedInstance), this.delegate);
                this.initialized = true;
                if (this.getMapping().getOrderBy() != null) {
                    mapping.sortList(managedInstance.getInstance());
                }
                managedInstance.updateCollectionCache(mapping);
            }
            this.initialized = true;
        }
    }

    @Override
    public boolean isEmpty() {
        this.initialize();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Iterator<E> iterator() {
        this.initialize();
        return new WrappedIterator<E>(this.delegate.iterator()){

            @Override
            public void remove() {
                ManagedList.this.snapshot();
                ManagedList.this.changed();
                super.remove();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        this.initialize();
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.initialize();
        return new ManagedListIterator(this.delegate.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.initialize();
        return new ManagedListIterator(this.delegate.listIterator(index));
    }

    private UnsupportedOperationException noDuplicates() {
        return new UnsupportedOperationException("Duplicates are not supported");
    }

    @Override
    public void refreshChildren() {
        if (this.initialized) {
            super.reset();
            this.snapshot = null;
            this.delegate.clear();
            this.delegate.addAll(this.getMapping().loadCollection(this.getManagedInstance()));
        }
    }

    @Override
    public E remove(int index) {
        this.snapshot();
        E e = this.delegate.remove(index);
        this.changed();
        return e;
    }

    @Override
    public boolean remove(Object o) {
        this.snapshot();
        if (this.delegate.remove(o)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.retainAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    protected void removeChild(E child) {
        this.delegate.remove(child);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.snapshot();
        if (this.delegate.retainAll(c)) {
            this.changed();
            return true;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        this.snapshot();
        if (this.delegate.contains(element) && ObjectUtils.notEqual(element, this.delegate.get(index))) {
            throw this.noDuplicates();
        }
        this.changed();
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        this.initialize();
        return this.delegate.size();
    }

    @Override
    protected void snapshot() {
        this.initialize();
        if (this.getManagedInstance() != null && this.snapshot == null) {
            this.snapshot = Lists.newArrayList(this.delegate);
            this.reset();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.initialize();
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        this.initialize();
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.initialize();
        return this.delegate.toArray(a);
    }

    public String toString() {
        String instance = this.getManagedInstance().getType().getName() + "@" + this.getManagedInstance().getId().getId();
        return "ManagedList [initialized=" + this.initialized + ", managedInstance=" + instance + ", delegate=" + this.delegate + ", snapshot=" + this.snapshot + ", mapping=" + this.getMapping() + "]";
    }

    private final class ManagedListIterator
    extends WrappedListIterator<E> {
        private E last;

        private ManagedListIterator(ListIterator<E> delegate) {
            super(delegate);
        }

        @Override
        public void add(E e) {
            ManagedList.this.snapshot();
            ManagedList.this.changed();
            if (e == null) {
                throw new NullPointerException();
            }
            if (ManagedList.this.delegate.contains(e)) {
                throw ManagedList.this.noDuplicates();
            }
            super.add(e);
        }

        @Override
        public E next() {
            this.last = super.next();
            return this.last;
        }

        @Override
        public E previous() {
            this.last = super.previous();
            return this.last;
        }

        @Override
        public void remove() {
            ManagedList.this.snapshot();
            ManagedList.this.changed();
            super.remove();
        }

        @Override
        public void set(E e) {
            ManagedList.this.snapshot();
            ManagedList.this.changed();
            if (e == null) {
                throw new NullPointerException();
            }
            if (ManagedList.this.delegate.contains(e) && ObjectUtils.notEqual(e, this.last)) {
                throw ManagedList.this.noDuplicates();
            }
            super.set(e);
        }
    }
}

