/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.TemporalType;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Type;
import org.batoo.jpa.core.impl.criteria.CompoundSelectionImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.InPredicate;
import org.batoo.jpa.core.impl.criteria.OrderImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.AggregationExpression;
import org.batoo.jpa.core.impl.criteria.expression.AllAnyExpression;
import org.batoo.jpa.core.impl.criteria.expression.ArithmeticExression;
import org.batoo.jpa.core.impl.criteria.expression.CaseImpl;
import org.batoo.jpa.core.impl.criteria.expression.CaseTransformationExpression;
import org.batoo.jpa.core.impl.criteria.expression.CoalesceExpression;
import org.batoo.jpa.core.impl.criteria.expression.ComparisonExpression;
import org.batoo.jpa.core.impl.criteria.expression.ConcatExpression;
import org.batoo.jpa.core.impl.criteria.expression.CountExpression;
import org.batoo.jpa.core.impl.criteria.expression.CurrentTemporalExpression;
import org.batoo.jpa.core.impl.criteria.expression.EntityConstantExpression;
import org.batoo.jpa.core.impl.criteria.expression.ExistsExpression;
import org.batoo.jpa.core.impl.criteria.expression.ExpressionConverter;
import org.batoo.jpa.core.impl.criteria.expression.FunctionExpression;
import org.batoo.jpa.core.impl.criteria.expression.IsEmptyExpression;
import org.batoo.jpa.core.impl.criteria.expression.LikeExpression;
import org.batoo.jpa.core.impl.criteria.expression.LocateExpression;
import org.batoo.jpa.core.impl.criteria.expression.MemberOfExpression;
import org.batoo.jpa.core.impl.criteria.expression.NegationExpression;
import org.batoo.jpa.core.impl.criteria.expression.NullExpression;
import org.batoo.jpa.core.impl.criteria.expression.NullIfExpression;
import org.batoo.jpa.core.impl.criteria.expression.NumericFunctionExpression;
import org.batoo.jpa.core.impl.criteria.expression.NumericFunctionType;
import org.batoo.jpa.core.impl.criteria.expression.ParameterExpressionImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.criteria.expression.SimpleCaseImpl;
import org.batoo.jpa.core.impl.criteria.expression.SimpleConstantExpression;
import org.batoo.jpa.core.impl.criteria.expression.SizeExpression;
import org.batoo.jpa.core.impl.criteria.expression.SubstringExpression;
import org.batoo.jpa.core.impl.criteria.expression.TrimExpression;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public class CriteriaBuilderImpl
implements CriteriaBuilder {
    private final MetamodelImpl metamodel;

    public CriteriaBuilderImpl(MetamodelImpl metamodel) {
        this.metamodel = metamodel;
    }

    public <N extends Number> Expression<N> abs(Expression<N> x) {
        return new NumericFunctionExpression(NumericFunctionType.ABS, x, null);
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new AllAnyExpression<Y>(true, subquery);
    }

    public PredicateImpl and(Expression<Boolean> x, Expression<Boolean> y) {
        return new PredicateImpl(false, Predicate.BooleanOperator.AND, x, y);
    }

    public PredicateImpl and(Predicate ... restrictions) {
        return new PredicateImpl(false, Predicate.BooleanOperator.AND, restrictions);
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new AllAnyExpression<Y>(false, subquery);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return new CompoundSelectionImpl<Object[]>(Object[].class, selections);
    }

    public OrderImpl asc(Expression<?> x) {
        return new OrderImpl(x, false);
    }

    public <N extends Number> Expression<Double> avg(Expression<N> x) {
        return new AggregationExpression<Double>(AggregationExpression.AggregationFunctionType.AVG, x);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Expression<? extends Y> x, Expression<? extends Y> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.BETWEEN, v, x, y));
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> v, Y x, Y y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.BETWEEN, v, this.createConstant(x), this.createConstant(y)));
    }

    public <T> CoalesceExpression<T> coalesce() {
        return new CoalesceExpression();
    }

    public <Y> CoalesceExpression<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new CoalesceExpression<Y>(x, y);
    }

    public <Y> CoalesceExpression<Y> coalesce(Expression<? extends Y> x, Y y) {
        return new CoalesceExpression<Y>(x, this.createConstant(y));
    }

    public Expression<String> concat(Expression<String> x, Expression<String> y) {
        return new ConcatExpression(x, y);
    }

    public Expression<String> concat(Expression<String> x, String y) {
        return new ConcatExpression(x, this.createConstant(y));
    }

    public Expression<String> concat(String x, Expression<String> y) {
        return new ConcatExpression(this.createConstant(x), y);
    }

    public PredicateImpl conjunction() {
        return new PredicateImpl(new AbstractExpression[0]);
    }

    public <Y> CompoundSelectionImpl<Y> construct(Class<Y> resultClass, Selection<?> ... selections) {
        return new CompoundSelectionImpl<Y>(resultClass, selections);
    }

    public Expression<Long> count(Expression<?> x) {
        return new CountExpression(x, false);
    }

    public Expression<Long> countDistinct(Expression<?> x) {
        return new CountExpression(x, true);
    }

    private <X> AbstractExpression<X> createConstant(X x) {
        if (x == null) {
            throw new NullPointerException("Constant expression cannot be null");
        }
        Class<?> clazz = x instanceof EnhancedInstance ? x.getClass().getSuperclass() : x.getClass();
        TypeImpl<?> type = this.metamodel.type(clazz);
        if (type == null || type.getPersistenceType() == Type.PersistenceType.MAPPED_SUPERCLASS) {
            throw new IllegalArgumentException("Cannot locate a type for the constant class: " + x);
        }
        return type.getPersistenceType() == Type.PersistenceType.BASIC ? new SimpleConstantExpression(type, x) : new EntityConstantExpression(type, x);
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, Object.class);
    }

    public <T> CriteriaQueryImpl<T> createQuery(Class<T> resultClass) {
        return new CriteriaQueryImpl<T>(this.metamodel, resultClass);
    }

    public CriteriaQueryImpl<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, Tuple.class);
    }

    public CurrentTemporalExpression<Date> currentDate() {
        return new CurrentTemporalExpression<Date>(TemporalType.DATE, Date.class);
    }

    public Expression<Time> currentTime() {
        return new CurrentTemporalExpression<Time>(TemporalType.TIME, Time.class);
    }

    public Expression<Timestamp> currentTimestamp() {
        return new CurrentTemporalExpression<Timestamp>(TemporalType.TIMESTAMP, Timestamp.class);
    }

    public OrderImpl desc(Expression<?> x) {
        return new OrderImpl(x, true);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.SUBTRACT, x, y);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> x, N y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.SUBTRACT, x, this.createConstant(y));
    }

    public <N extends Number> Expression<N> diff(N x, Expression<? extends N> y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.SUBTRACT, this.createConstant(x), y);
    }

    public PredicateImpl disjunction() {
        return new PredicateImpl(true, Predicate.BooleanOperator.AND, new Predicate[0]);
    }

    public PredicateImpl equal(Expression<?> x, Expression<?> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.EQUAL, x, y));
    }

    public PredicateImpl equal(Expression<?> x, Object y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.EQUAL, x, this.createConstant(y)));
    }

    public PredicateImpl exists(Subquery<?> subquery) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ExistsExpression(subquery));
    }

    public <T> FunctionExpression<T> function(String name, Class<T> type, Expression<?> ... args) {
        return new FunctionExpression<T>(type, name, args);
    }

    public PredicateImpl ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER_OR_EQUAL, x, y));
    }

    public PredicateImpl ge(Expression<? extends Number> x, Number y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER_OR_EQUAL, x, this.createConstant(y)));
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public <Y extends Comparable<? super Y>> PredicateImpl greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER, x, y));
    }

    public <Y extends Comparable<? super Y>> PredicateImpl greaterThan(Expression<? extends Y> x, Y y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER, x, this.createConstant(y)));
    }

    public <Y extends Comparable<? super Y>> PredicateImpl greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER_OR_EQUAL, x, y));
    }

    public <Y extends Comparable<? super Y>> PredicateImpl greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER_OR_EQUAL, x, this.createConstant(y)));
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> x) {
        return new AggregationExpression(AggregationExpression.AggregationFunctionType.MAX, x);
    }

    public PredicateImpl gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.GREATER, x, y));
    }

    public PredicateImpl gt(Expression<? extends Number> x, Number y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS, x, this.createConstant(y)));
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new InPredicate<T>(expression);
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new IsEmptyExpression(collection, false));
    }

    public PredicateImpl isFalse(Expression<Boolean> x) {
        return new PredicateImpl((AbstractExpression<Boolean>)((AbstractExpression)x)).not();
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new MemberOfExpression<C, E>(false, this.createConstant(elem), collection));
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elem, Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new MemberOfExpression<C, E>(false, elem, collection));
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new IsEmptyExpression(collection, true));
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new MemberOfExpression<C, E>(true, this.createConstant(elem), collection));
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> elem, Expression<C> collection) {
        return new PredicateImpl((AbstractExpression<Boolean>)new MemberOfExpression<C, E>(true, elem, collection));
    }

    public PredicateImpl isNotNull(Expression<?> x) {
        return ((AbstractExpression)x).isNotNull();
    }

    public PredicateImpl isNull(Expression<?> x) {
        return ((AbstractExpression)x).isNull();
    }

    public PredicateImpl isTrue(Expression<Boolean> x) {
        return new PredicateImpl((AbstractExpression<Boolean>)((AbstractExpression)x));
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        throw new UnsupportedOperationException();
    }

    public PredicateImpl le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS_OR_EQUAL, x, y));
    }

    public PredicateImpl le(Expression<? extends Number> x, Number y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS_OR_EQUAL, x, this.createConstant(y)));
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> x) {
        return new AggregationExpression(AggregationExpression.AggregationFunctionType.MIN, x);
    }

    public Expression<Integer> length(Expression<String> x) {
        return new NumericFunctionExpression<Integer>(NumericFunctionType.LENGTH, x, null);
    }

    public <Y extends Comparable<? super Y>> PredicateImpl lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS, x, y));
    }

    public <Y extends Comparable<? super Y>> PredicateImpl lessThan(Expression<? extends Y> x, Y y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS, x, this.createConstant(y)));
    }

    public <Y extends Comparable<? super Y>> PredicateImpl lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS_OR_EQUAL, x, y));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS_OR_EQUAL, x, this.createConstant(y)));
    }

    public PredicateImpl like(Expression<String> x, Expression<String> pattern) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, null, false));
    }

    public PredicateImpl like(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, new EntityConstantExpression<Character>(null, Character.valueOf(escapeChar)), false));
    }

    public PredicateImpl like(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, escapeChar, false));
    }

    public PredicateImpl like(Expression<String> x, String pattern) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), null, false));
    }

    public PredicateImpl like(Expression<String> x, String pattern, char escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), new EntityConstantExpression<Character>(null, Character.valueOf(escapeChar)), false));
    }

    public PredicateImpl like(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), escapeChar, false));
    }

    public <T> SimpleConstantExpression<T> literal(T value) {
        return new SimpleConstantExpression(this.metamodel.createBasicType(value.getClass()), value);
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern) {
        return new LocateExpression(x, pattern, null);
    }

    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern, Expression<Integer> from) {
        return new LocateExpression(x, pattern, from);
    }

    public Expression<Integer> locate(Expression<String> x, String pattern) {
        return new LocateExpression(x, new EntityConstantExpression<String>(null, pattern), null);
    }

    public Expression<Integer> locate(Expression<String> x, String pattern, int from) {
        return new LocateExpression(x, new EntityConstantExpression<String>(null, pattern), new EntityConstantExpression<Integer>(null, from));
    }

    public Expression<String> lower(Expression<String> x) {
        return new CaseTransformationExpression(x, CaseTransformationExpression.CaseTransformationType.LOWER);
    }

    public PredicateImpl lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS, x, y));
    }

    public PredicateImpl lt(Expression<? extends Number> x, Number y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.LESS, x, new EntityConstantExpression<Number>(null, y)));
    }

    public <N extends Number> Expression<N> max(Expression<N> x) {
        return new AggregationExpression(AggregationExpression.AggregationFunctionType.MAX, x);
    }

    public <N extends Number> Expression<N> min(Expression<N> x) {
        return new AggregationExpression(AggregationExpression.AggregationFunctionType.MIN, x);
    }

    public Expression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return new NumericFunctionExpression<Integer>(NumericFunctionType.MOD, x, y);
    }

    public Expression<Integer> mod(Expression<Integer> x, Integer y) {
        return new NumericFunctionExpression<Integer>(NumericFunctionType.MOD, x, new EntityConstantExpression<Integer>(null, y));
    }

    public Expression<Integer> mod(Integer x, Expression<Integer> y) {
        return new NumericFunctionExpression<Integer>(NumericFunctionType.MOD, new EntityConstantExpression<Integer>(null, x), y);
    }

    public <N extends Number> Expression<N> neg(Expression<N> x) {
        return new NegationExpression<N>(x);
    }

    public PredicateImpl not(Expression<Boolean> restriction) {
        return new PredicateImpl(true, Predicate.BooleanOperator.AND, restriction);
    }

    public PredicateImpl notEqual(Expression<?> x, Expression<?> y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.NOT_EQUAL, x, y));
    }

    public PredicateImpl notEqual(Expression<?> x, Object y) {
        return new PredicateImpl((AbstractExpression<Boolean>)new ComparisonExpression(ComparisonExpression.Comparison.NOT_EQUAL, x, this.createConstant(y)));
    }

    public PredicateImpl notLike(Expression<String> x, Expression<String> pattern) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, null, true));
    }

    public PredicateImpl notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, new EntityConstantExpression<Character>(null, Character.valueOf(escapeChar)), true));
    }

    public PredicateImpl notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, pattern, escapeChar, true));
    }

    public PredicateImpl notLike(Expression<String> x, String pattern) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), null, true));
    }

    public PredicateImpl notLike(Expression<String> x, String pattern, char escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), new EntityConstantExpression<Character>(null, Character.valueOf(escapeChar)), true));
    }

    public PredicateImpl notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return new PredicateImpl((AbstractExpression<Boolean>)new LikeExpression(x, new EntityConstantExpression<String>(null, pattern), escapeChar, true));
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return new NullIfExpression<Y>(x, y);
    }

    public <Y> Expression<Y> nullif(Expression<Y> x, Y y) {
        return new NullIfExpression<Y>(x, this.createConstant(y));
    }

    public <T> Expression<T> nullLiteral(Class<T> resultClass) {
        return new NullExpression<T>(resultClass);
    }

    public PredicateImpl or(Expression<Boolean> x, Expression<Boolean> y) {
        return new PredicateImpl(false, Predicate.BooleanOperator.OR, x, y);
    }

    public PredicateImpl or(Predicate ... restrictions) {
        return new PredicateImpl(false, Predicate.BooleanOperator.OR, restrictions);
    }

    public <T> ParameterExpressionImpl<T> parameter(Class<T> paramClass) {
        return this.parameter((Class)paramClass, (String)null);
    }

    public <T> ParameterExpressionImpl<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel.type(paramClass), paramClass, name);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.MULTIPLY, x, y);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> x, N y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.MULTIPLY, x, new EntityConstantExpression<N>(null, y));
    }

    public <N extends Number> Expression<N> prod(N x, Expression<? extends N> y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.MULTIPLY, new EntityConstantExpression<N>(null, x), y);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ArithmeticExression<Number>(ArithmeticExression.ArithmeticOperation.DIVIDE, x, y);
    }

    public Expression<Number> quot(Expression<? extends Number> x, Number y) {
        return new ArithmeticExression<Number>(ArithmeticExression.ArithmeticOperation.SUBTRACT, x, new EntityConstantExpression<Number>(null, y));
    }

    public Expression<Number> quot(Number x, Expression<? extends Number> y) {
        return new ArithmeticExression<Number>(ArithmeticExression.ArithmeticOperation.SUBTRACT, new EntityConstantExpression<Number>(null, x), y);
    }

    public <R> CaseImpl<R> selectCase() {
        return new CaseImpl();
    }

    public <C, R> SimpleCaseImpl<C, R> selectCase(Expression<? extends C> expression) {
        return new SimpleCaseImpl(expression);
    }

    public <C extends Collection<?>> Expression<Integer> size(C collection) {
        return new EntityConstantExpression<Integer>(null, collection != null ? collection.size() : 0);
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> collection) {
        return new SizeExpression<C>(collection);
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new AllAnyExpression<Y>(false, subquery);
    }

    public Expression<Double> sqrt(Expression<? extends Number> x) {
        return new NumericFunctionExpression<Double>(NumericFunctionType.SQRT, x, null);
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from) {
        return new SubstringExpression(x, from, null);
    }

    public Expression<String> substring(Expression<String> x, Expression<Integer> from, Expression<Integer> len) {
        return new SubstringExpression(x, from, len);
    }

    public Expression<String> substring(Expression<String> x, int from) {
        return new SubstringExpression(x, new EntityConstantExpression<Integer>(this.metamodel.type(Integer.class), from), null);
    }

    public Expression<String> substring(Expression<String> x, int from, int len) {
        return new SubstringExpression(x, new EntityConstantExpression<Integer>(this.metamodel.type(Integer.class), from), new EntityConstantExpression<Integer>(this.metamodel.type(Integer.class), len));
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.ADD, x, y);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> x, N y) {
        TypeImpl<?> type = this.metamodel.type(y.getClass());
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.ADD, x, new EntityConstantExpression(type, y));
    }

    public <N extends Number> Expression<N> sum(Expression<N> x) {
        return new AggregationExpression(AggregationExpression.AggregationFunctionType.SUM, x);
    }

    public <N extends Number> Expression<N> sum(N x, Expression<? extends N> y) {
        TypeImpl<?> type = this.metamodel.type(x.getClass());
        return new ArithmeticExression<N>(ArithmeticExression.ArithmeticOperation.ADD, new EntityConstantExpression(type, x), y);
    }

    public Expression<Double> sumAsDouble(Expression<Float> x) {
        return new AggregationExpression<Double>(AggregationExpression.AggregationFunctionType.SUM, x);
    }

    public Expression<Long> sumAsLong(Expression<Integer> x) {
        return new AggregationExpression<Long>(AggregationExpression.AggregationFunctionType.SUM, x);
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.BIG_DECIMAL);
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.BIG_INTEGER);
    }

    public Expression<Double> toDouble(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.DOUBLE);
    }

    public Expression<Float> toFloat(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.FLOAT);
    }

    public Expression<Integer> toInteger(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.INTEGER);
    }

    public Expression<Long> toLong(Expression<? extends Number> number) {
        return ((AbstractExpression)number).setConverter(ExpressionConverter.LONG);
    }

    public Expression<String> toString(Expression<Character> character) {
        return ((AbstractExpression)character).setConverter(ExpressionConverter.STRING);
    }

    public Expression<String> trim(char t, Expression<String> x) {
        return new TrimExpression(null, new EntityConstantExpression<Character>(this.metamodel.type(Character.class), Character.valueOf(t)), x);
    }

    public Expression<String> trim(Expression<Character> t, Expression<String> x) {
        return new TrimExpression(null, t, x);
    }

    public Expression<String> trim(Expression<String> x) {
        return new TrimExpression(CriteriaBuilder.Trimspec.BOTH, null, x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, char t, Expression<String> x) {
        return new TrimExpression(ts, new EntityConstantExpression<Character>(this.metamodel.type(Character.class), Character.valueOf(t)), x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<Character> t, Expression<String> x) {
        return new TrimExpression(ts, t, x);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec ts, Expression<String> x) {
        return new TrimExpression(ts, null, x);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return null;
    }

    public Expression<String> upper(Expression<String> x) {
        return new CaseTransformationExpression(x, CaseTransformationExpression.CaseTransformationType.UPPER);
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        throw new UnsupportedOperationException();
    }
}

