/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CompoundSelectionImpl;
import org.batoo.jpa.core.impl.criteria.OrderImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;

public class CriteriaQueryImpl<T>
extends AbstractCriteriaQueryImpl<T>
implements CriteriaQuery<T> {
    private final ArrayList<OrderImpl> orderList = Lists.newArrayList();

    public CriteriaQueryImpl(MetamodelImpl metamodel) {
        super(metamodel, null);
    }

    public CriteriaQueryImpl(MetamodelImpl metamodel, Class<T> resultType) {
        super(metamodel, resultType);
    }

    @Override
    public CriteriaQueryImpl<T> distinct(boolean distinct) {
        return (CriteriaQueryImpl)super.distinct(distinct);
    }

    @Override
    public String generateJpql() {
        if (this.orderList.size() > 0) {
            String orderBy = Joiner.on((String)", ").join((Iterable)Lists.transform(this.orderList, (Function)new Function<OrderImpl, String>(){

                public String apply(OrderImpl input) {
                    return input.isAscending() ? input.getExpression().generateJpqlRestriction(CriteriaQueryImpl.this) + " asc" : input.getExpression().generateJpqlRestriction(CriteriaQueryImpl.this) + " desc";
                }
            }));
            return super.generateJpql() + "\norder by\n\t" + orderBy;
        }
        return super.generateJpql();
    }

    @Override
    public String generateSql() {
        if (this.orderList.size() > 0) {
            String orderBy = Joiner.on((String)", ").join((Iterable)Lists.transform(this.orderList, (Function)new Function<OrderImpl, String>(){

                public String apply(OrderImpl input) {
                    return input.isAscending() ? input.getExpression().generateSqlSelect(CriteriaQueryImpl.this, false) + " asc" : input.getExpression().generateSqlSelect(CriteriaQueryImpl.this, false) + " desc";
                }
            }));
            return super.generateSql() + "\nORDER BY\n\t" + orderBy;
        }
        return super.generateSql();
    }

    public List<Order> getOrderList() {
        ArrayList orderList = Lists.newArrayList();
        orderList.addAll(this.orderList);
        return orderList;
    }

    @Override
    public CriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        return (CriteriaQuery)super.groupBy(grouping);
    }

    @Override
    public CriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        return (CriteriaQuery)super.groupBy(grouping);
    }

    @Override
    public CriteriaQuery<T> having(Expression<Boolean> restriction) {
        return (CriteriaQuery)super.having(restriction);
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... restrictions) {
        return (CriteriaQuery)super.having(restrictions);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        return this.select(new CompoundSelectionImpl(this.getResultType(), selectionList));
    }

    public CriteriaQueryImpl<T> multiselect(Selection<?> ... selections) {
        return this.select(new CompoundSelectionImpl(this.getResultType(), selections));
    }

    public CriteriaQuery<T> orderBy(List<Order> o) {
        this.orderList.clear();
        for (Order order : o) {
            this.orderList.add((OrderImpl)order);
        }
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... o) {
        this.orderList.clear();
        for (Order order : o) {
            this.orderList.add((OrderImpl)order);
        }
        return this;
    }

    @Override
    public CriteriaQueryImpl<T> select(Selection<? extends T> selection) {
        return (CriteriaQueryImpl)super.select(selection);
    }

    public String toString() {
        return this.getJpql();
    }

    @Override
    public CriteriaQueryImpl<T> where(Expression<Boolean> restriction) {
        return (CriteriaQueryImpl)super.where(restriction);
    }

    @Override
    public CriteriaQueryImpl<T> where(Predicate ... restrictions) {
        return (CriteriaQueryImpl)super.where(restrictions);
    }
}

