/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria;

import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;

public class RootImpl<X>
extends AbstractFrom<X, X>
implements Root<X> {
    private final EntityTypeImpl<X> entity;

    public RootImpl(EntityTypeImpl<X> entity) {
        super(entity);
        this.entity = entity;
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        super.generateJpqlSelect(query, selected);
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.getAlias();
        }
        return this.getModel().getName();
    }

    public String generateSqlFrom(BaseQueryImpl<?> query) {
        EntityTable primaryTable = this.entity.getRootType().getPrimaryTable();
        if (query.isQuery()) {
            return primaryTable.getQName() + " " + this.getFetchRoot().getTableAlias(query, primaryTable);
        }
        return primaryTable.getQName();
    }

    @Override
    protected <C, Y> Mapping<? super X, C, Y> getMapping(String name) {
        Mapping child = this.entity.getRootMapping().getChild(name);
        if (child == null) {
            throw this.cannotDereference(name);
        }
        return child;
    }

    public EntityType<X> getModel() {
        return this.entity;
    }
}

