/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public abstract class AbstractParameterExpressionImpl<T>
extends AbstractExpression<T> {
    private TypeImpl<?> type;

    public AbstractParameterExpressionImpl(TypeImpl<T> type, Class<T> paramClass) {
        super(paramClass);
        this.type = type;
    }

    protected abstract void ensureAlias(BaseQueryImpl<?> var1);

    protected void ensureTypeResolved(MetamodelImpl metamodel) {
        if (this.type == null) {
            this.type = metamodel.type(this.getJavaType());
        }
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.ensureAlias(query);
        return null;
    }

    public int getExpandedCount(MetamodelImpl metamodelImpl) {
        if (this.getJavaType() == Class.class) {
            return 1;
        }
        this.ensureTypeResolved(metamodelImpl);
        if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
            return 1;
        }
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            return ((EmbeddableTypeImpl)this.type).getAttributeCount();
        }
        return ((EntityTypeImpl)this.type).getPrimaryTable().getPkColumns().size();
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        query.setNextSqlParam(this);
        String[] restrictions = new String[this.getExpandedCount(query.getMetamodel())];
        for (int i = 0; i < restrictions.length; ++i) {
            restrictions[i] = "?";
        }
        return restrictions;
    }

    protected void setParameter(MetamodelImpl metamodel, Object[] parameters, MutableInt sqlIndex, Object value) {
        if (this.getJavaType() == Class.class) {
            EntityType entity = metamodel.entity((Class)value);
            if (entity == null) {
                throw new IllegalArgumentException("Type is not managed: " + value);
            }
            if (entity.getRootType().getInheritanceType() == null) {
                throw new IllegalArgumentException("Entity does not have inheritence: " + entity.getName());
            }
            parameters[sqlIndex.intValue()] = entity.getDiscriminatorValue();
            sqlIndex.increment();
        } else {
            this.ensureTypeResolved(metamodel);
            if (this.type.getPersistenceType() == Type.PersistenceType.BASIC) {
                parameters[sqlIndex.intValue()] = value;
                sqlIndex.increment();
            } else if (this.type.getPersistenceType() == Type.PersistenceType.ENTITY) {
                EntityTypeImpl type = (EntityTypeImpl)this.type;
                this.setParameter(parameters, sqlIndex, value, type);
            } else {
                EmbeddableTypeImpl type = (EmbeddableTypeImpl)this.type;
                this.setParameter(parameters, sqlIndex, value, type);
            }
        }
    }

    private void setParameter(Object[] parameters, MutableInt sqlIndex, Object value, EmbeddableTypeImpl<?> type) {
        SingularAttributeImpl<?, ?>[] attributes;
        block5: for (SingularAttributeImpl<?, ?> attribute : attributes = type.getSingularMappings()) {
            switch (attribute.getPersistentAttributeType()) {
                case BASIC: {
                    parameters[sqlIndex.intValue()] = attribute.get(value);
                    sqlIndex.increment();
                    continue block5;
                }
                case MANY_TO_ONE: 
                case ONE_TO_ONE: {
                    this.setParameter(parameters, sqlIndex, attribute.get(value), (EntityTypeImpl)attribute.getType());
                    continue block5;
                }
                case EMBEDDED: {
                    this.setParameter(parameters, sqlIndex, attribute.get(value), (EmbeddableTypeImpl)this.type);
                }
            }
        }
    }

    private void setParameter(Object[] parameters, MutableInt sqlIndex, Object value, EntityTypeImpl<?> type) {
        for (AbstractColumn column : type.getPrimaryTable().getPkColumns()) {
            parameters[sqlIndex.intValue()] = column.getMapping().get(value);
            sqlIndex.increment();
        }
    }
}

