/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class ConcatExpression
extends AbstractExpression<String> {
    private final ArrayList<Expression<String>> arguments;
    private String alias;

    public ConcatExpression(Expression<String> ... arguments) {
        super(String.class);
        this.arguments = Lists.newArrayList((Object[])arguments);
    }

    @Override
    public String generateJpqlRestriction(final BaseQueryImpl<?> query) {
        String expressions = Joiner.on((String)", ").join((Iterable)Lists.transform(this.arguments, (Function)new Function<Expression<String>, String>(){

            public String apply(Expression<String> input) {
                return ((AbstractExpression)input).generateJpqlRestriction(query);
            }
        }));
        return "concat (" + expressions + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (selected && StringUtils.isBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    private String generateSqlRestriction(final BaseQueryImpl<?> query) {
        return query.getJdbcAdaptor().applyConcat(Lists.transform(this.arguments, (Function)new Function<Expression<String>, String>(){

            public String apply(Expression<String> input) {
                return ((AbstractExpression)input).getSqlRestrictionFragments(query)[0];
            }
        }));
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.generateSqlRestriction(query) + " AS " + this.alias;
        }
        return this.generateSqlRestriction(query);
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{this.generateSqlRestriction(query)};
    }

    @Override
    public String handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (String)row.getObject(this.alias);
    }
}

