/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public class ParameterExpressionImpl<T>
extends AbstractParameterExpressionImpl<T>
implements ParameterExpression<T> {
    private Integer position;

    public ParameterExpressionImpl(TypeImpl<T> type, Class<T> paramClass, String name) {
        super(type, paramClass);
        if (StringUtils.isNotBlank((String)name)) {
            this.alias(name);
        }
    }

    @Override
    protected void ensureAlias(BaseQueryImpl<?> query) {
        if (this.position == null) {
            this.position = query.getAlias(this);
            if (StringUtils.isBlank((String)this.getAlias())) {
                this.alias("param" + this.position);
            }
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        return ":" + this.getAlias();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.ensureAlias(query);
        return null;
    }

    public String getName() {
        return this.getAlias();
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public Integer getPosition() {
        return this.position;
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object value = query.getParameterValue(this);
        return (T)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    @Override
    public void setParameter(MetamodelImpl metamodel, Object[] parameters, MutableInt sqlIndex, Object value) {
        super.setParameter(metamodel, parameters, sqlIndex, value);
    }
}

