/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.join;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.EntityTypeExpression;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractJoin;
import org.batoo.jpa.core.impl.criteria.join.CollectionJoinImpl;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.join.ListJoinImpl;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.criteria.join.SetJoinImpl;
import org.batoo.jpa.core.impl.criteria.join.SingularJoin;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;

public abstract class AbstractFrom<Z, X>
extends ParentPath<Z, X>
implements From<Z, X>,
Joinable {
    private final FetchParentImpl<Z, X> fetchRoot;
    private final EntityTypeImpl<X> entity;
    private final Set<AbstractJoin<X, ?>> joins = Sets.newHashSet();
    private final JoinedMapping<? super Z, ?, X> mapping;
    private boolean selected;

    public AbstractFrom(AbstractFrom<?, Z> parent, TypeImpl<X> type, JoinedMapping<? super Z, ?, X> mapping, JoinType joinType) {
        super(parent, type.getJavaType());
        this.fetchRoot = parent.getFetchRoot().join(mapping.getAttribute().getName(), joinType);
        if (type.getPersistenceType() == Type.PersistenceType.ENTITY) {
            this.entity = (EntityTypeImpl)type;
            this.mapping = null;
        } else {
            this.entity = null;
            this.mapping = mapping;
        }
    }

    public AbstractFrom(EntityTypeImpl<X> entity) {
        super(null, entity.getJavaType());
        this.fetchRoot = new FetchParentImpl(entity);
        this.entity = entity;
        this.mapping = null;
    }

    protected void ensureAlias(BaseQueryImpl<?> query) {
        if (StringUtils.isBlank((String)this.getAlias())) {
            this.alias(query.getAlias(this));
        }
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute) {
        return this.fetchRoot.fetch((PluralAttribute)attribute);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute, JoinType jt) {
        return this.fetchRoot.fetch((PluralAttribute)attribute, jt);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attribute) {
        return this.fetchRoot.fetch((SingularAttribute)attribute);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        return this.fetchRoot.fetch((SingularAttribute)attribute, jt);
    }

    public <Y> Fetch<X, Y> fetch(String attributeName) {
        return this.fetchRoot.fetch(attributeName);
    }

    public <Y> Fetch<X, Y> fetch(String attributeName, JoinType jt) {
        return this.fetchRoot.fetch(attributeName, jt);
    }

    public String generateDiscrimination(boolean noQualification) {
        return this.fetchRoot.generateDiscrimination(noQualification);
    }

    public String generateJpqlJoins(AbstractCriteriaQueryImpl<?> criteriaQuery) {
        String fetches;
        this.ensureAlias(criteriaQuery);
        ArrayList joins = Lists.newArrayList();
        if (this.selected && StringUtils.isNotBlank((String)(fetches = this.fetchRoot.generateJpqlFetches(this.getAlias())))) {
            joins.add(fetches);
        }
        for (AbstractJoin<X, ?> join : this.joins) {
            joins.add(join.generateJpqlJoins(criteriaQuery));
        }
        return Joiner.on((String)"\n").join((Iterable)joins);
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        return this.getAlias();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.selected |= selected;
        return null;
    }

    public void generateSqlJoins(AbstractCriteriaQueryImpl<?> query, Map<Joinable, String> joins) {
        this.fetchRoot.generateSqlJoins(query, joins, this.selected);
        for (AbstractJoin<X, ?> join : this.joins) {
            join.generateSqlJoins(query, joins);
        }
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.select(selected);
        return this.fetchRoot.generateSqlSelect(query, selected, this.getParentPath() == null);
    }

    public From<Z, X> getCorrelationParent() {
        return null;
    }

    public EntityTypeImpl<X> getEntity() {
        return this.entity;
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetchRoot.getFetches();
    }

    @Override
    public FetchParentImpl<Z, X> getFetchRoot() {
        return this.fetchRoot;
    }

    public Set<Join<X, ?>> getJoins() {
        HashSet joins = Sets.newHashSet();
        joins.addAll(this.joins);
        return joins;
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return this.fetchRoot.getSqlRestrictionFragments(query, MapJoinImpl.MapSelectType.VALUE);
    }

    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query, MapJoinImpl.MapSelectType selectType) {
        return this.fetchRoot.getSqlRestrictionFragments(query, selectType);
    }

    @Override
    public String getTableAlias(BaseQueryImpl<?> query, AbstractTable table) {
        return this.getFetchRoot().getTableAlias(query, table);
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        if (this.entity != null) {
            return this.fetchRoot.handle(session, row);
        }
        return this.fetchRoot.handleElementFetch(row).getValue();
    }

    public boolean isCorrelated() {
        return false;
    }

    @Override
    public boolean isEntityList() {
        return true;
    }

    public <Y> CollectionJoinImpl<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join((CollectionAttribute)collection, JoinType.INNER);
    }

    public <Y> CollectionJoinImpl<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        return (CollectionJoinImpl)this.join(collection.getName(), jt);
    }

    public <Y> ListJoinImpl<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join((ListAttribute)list, JoinType.INNER);
    }

    public <Y> ListJoinImpl<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        return (ListJoinImpl)this.join(list.getName(), jt);
    }

    public <K, V> MapJoinImpl<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join((MapAttribute)map, JoinType.INNER);
    }

    public <K, V> MapJoinImpl<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        return (MapJoinImpl)this.join(map.getName(), jt);
    }

    public <Y> SetJoinImpl<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join((SetAttribute)set, JoinType.INNER);
    }

    public <Y> SetJoinImpl<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        return (SetJoinImpl)this.join(set.getName(), jt);
    }

    public <Y> AbstractJoin<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join((SingularAttribute)attribute, JoinType.INNER);
    }

    public <Y> AbstractJoin<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        return this.join(attribute.getName(), jt);
    }

    public <Y> AbstractJoin<X, Y> join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    public <Y> AbstractJoin<X, Y> join(String attributeName, JoinType jt) {
        Mapping<Object, ?, ?> mapping = null;
        if (this.entity != null) {
            mapping = this.entity.getRootMapping().getChild(attributeName);
        } else if (this.mapping.getMappingType() == JoinedMapping.MappingType.ELEMENT_COLLECTION) {
            mapping = ((ElementCollectionMapping)this.mapping).getMapping(attributeName);
        } else if (this.mapping.getMappingType() == JoinedMapping.MappingType.EMBEDDABLE) {
            mapping = ((EmbeddedMapping)this.mapping).getChild(attributeName);
        }
        AbstractJoin join = null;
        JoinedMapping joinedMapping = (JoinedMapping)((Object)mapping);
        if (joinedMapping.getMappingType() == JoinedMapping.MappingType.SINGULAR_ASSOCIATION || joinedMapping.getMappingType() == JoinedMapping.MappingType.EMBEDDABLE) {
            join = new SingularJoin(this, joinedMapping, jt);
        } else {
            PluralAttributeImpl attribute = (PluralAttributeImpl)mapping.getAttribute();
            switch (attribute.getCollectionType()) {
                case SET: {
                    join = new SetJoinImpl(this, (PluralMapping)joinedMapping, jt);
                    break;
                }
                case COLLECTION: {
                    join = new CollectionJoinImpl(this, (PluralMapping)joinedMapping, jt);
                    break;
                }
                case LIST: {
                    join = new ListJoinImpl(this, (PluralMapping)joinedMapping, jt);
                    break;
                }
                case MAP: {
                    join = new MapJoinImpl(this, (PluralMapping)joinedMapping, jt);
                }
            }
        }
        this.joins.add(join);
        return join;
    }

    public <Y> CollectionJoinImpl<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    public <Y> CollectionJoinImpl<X, Y> joinCollection(String attributeName, JoinType jt) {
        return (CollectionJoinImpl)this.join(attributeName, jt);
    }

    public <Y> ListJoinImpl<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    public <Y> ListJoinImpl<X, Y> joinList(String attributeName, JoinType jt) {
        return (ListJoinImpl)this.join(attributeName, jt);
    }

    public <K, V> MapJoinImpl<X, K, V> joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    public <K, V> MapJoinImpl<X, K, V> joinMap(String attributeName, JoinType jt) {
        return (MapJoinImpl)this.join(attributeName, jt);
    }

    public <Y> SetJoinImpl<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    public <Y> SetJoinImpl<X, Y> joinSet(String attributeName, JoinType jt) {
        return (SetJoinImpl)this.join(attributeName, jt);
    }

    public void select(boolean selected) {
        this.selected |= selected;
    }

    public Expression<Class<? extends X>> type() {
        if (this.entity != null && this.entity.getRootType().getInheritanceType() != null) {
            return new EntityTypeExpression(this, this.entity.getRootType().getDiscriminatorColumn());
        }
        if (this.entity != null) {
            return new StaticTypeExpression(this, this.entity.getJavaType());
        }
        return new StaticTypeExpression(this, this.getModel().getBindableJavaType());
    }
}

