/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.StaticTypeExpression;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.criteria.path.ParentPath;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;

public class BasicPath<X>
extends AbstractPath<X> {
    private final BasicMapping<?, X> mapping;
    private String fieldAlias;

    public BasicPath(ParentPath<?, ?> parent, BasicMapping<?, X> mapping) {
        super(parent, mapping.getJavaType());
        this.mapping = mapping;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlRestriction(query));
        builder.append(".").append(this.mapping.getAttribute().getName());
        return builder.toString();
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean seleselectedcted) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentPath().generateJpqlSelect(query, false));
        builder.append(".").append(this.mapping.getAttribute().getName());
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        BasicColumn column = this.mapping.getColumn();
        Joinable rootPath = this.getRootPath();
        String tableAlias = rootPath.getTableAlias(query, column.getTable());
        this.fieldAlias = tableAlias + "_F" + query.getFieldAlias(tableAlias, column);
        if (selected) {
            return tableAlias + "." + column.getName() + " AS " + this.fieldAlias;
        }
        return tableAlias + "." + column.getName();
    }

    public BasicAttribute<?, X> getModel() {
        return this.mapping.getAttribute();
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        BasicColumn column = this.mapping.getColumn();
        String tableAlias = this.getRootPath().getTableAlias(query, column.getTable());
        if (query.isQuery()) {
            return new String[]{tableAlias + "." + column.getName()};
        }
        return new String[]{column.getName()};
    }

    @Override
    public X handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object value = this.mapping.getColumn().convertValue(row.getStatement().getConnection(), row.getObject(this.fieldAlias));
        return (X)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    public Expression<Class<? extends X>> type() {
        return new StaticTypeExpression(this, this.mapping.getJavaType());
    }
}

