/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.EnumType;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.apache.commons.io.IOUtils;
import org.batoo.jpa.common.reflect.ReflectHelper;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;

public abstract class AbstractColumn {
    private final Class<?> javaType;
    private final TemporalType temporalType;
    private final EnumType enumType;
    private final boolean lob;
    private final AbstractLocator locator;
    private final Class<?> numberType;
    private final Enum<?>[] values;
    private final Method method;

    public AbstractColumn(AbstractLocator locator) {
        this.javaType = null;
        this.locator = locator;
        this.temporalType = null;
        this.enumType = null;
        this.lob = false;
        this.values = null;
        this.method = null;
        this.numberType = null;
    }

    public AbstractColumn(Class<?> javaType, TemporalType temporalType, EnumType enumType, boolean lob, AbstractLocator locator) {
        this.javaType = javaType;
        this.temporalType = temporalType;
        this.enumType = enumType;
        this.lob = lob;
        this.locator = locator;
        Class<Object> clazz = this.numberType = Number.class.isAssignableFrom(javaType) ? javaType : null;
        if (this.enumType != null) {
            Class<?> enumJavaType = javaType;
            try {
                if (this.enumType == EnumType.ORDINAL) {
                    this.values = (Enum[])enumJavaType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    this.method = null;
                }
                this.values = null;
                this.method = enumJavaType.getMethod("valueOf", String.class);
            }
            catch (Exception e) {
                throw new MappingException("Unable to map enum type", this.locator);
            }
        } else {
            this.values = null;
            this.method = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertValue(Connection connection, Object value) {
        if (value == null) {
            return null;
        }
        if (this.temporalType != null) {
            switch (this.temporalType) {
                case DATE: {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Date(((java.util.Date)value).getTime());
                    }
                    return new Date(((Calendar)value).getTimeInMillis());
                }
                case TIME: {
                    if (value instanceof Time) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Time(((java.util.Date)value).getTime());
                    }
                    return new Time(((Calendar)value).getTimeInMillis());
                }
                case TIMESTAMP: {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof java.util.Date) {
                        return new Timestamp(((java.util.Date)value).getTime());
                    }
                    return new Timestamp(((Calendar)value).getTimeInMillis());
                }
            }
        }
        if (this.numberType != null) {
            return ReflectHelper.convertNumber((Number)value, this.numberType);
        }
        if (this.enumType != null) {
            Enum enumValue = (Enum)value;
            if (this.enumType == EnumType.ORDINAL) {
                return enumValue.ordinal();
            }
            return enumValue.name();
        }
        if (this.lob) {
            try {
                if (this.javaType == String.class) {
                    return new SerialClob(((String)value).toCharArray());
                }
                if (this.javaType == char[].class) {
                    return new SerialClob((char[])value);
                }
                if (this.javaType == byte[].class) {
                    return new SerialBlob((byte[])value);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                try {
                    oos.writeObject(value);
                }
                finally {
                    oos.close();
                }
                return new SerialBlob(os.toByteArray());
            }
            catch (Exception e) {
                throw new PersistenceException("Cannot set parameter", (Throwable)e);
            }
        }
        return value;
    }

    protected Object convertValueForSet(Object value) {
        if (value == null) {
            return null;
        }
        if (this.enumType != null) {
            if (this.enumType == EnumType.ORDINAL) {
                value = this.values[((Number)value).shortValue()];
            } else {
                try {
                    value = this.method.invoke(null, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.lob) {
            value = this.readLob(value);
        }
        return value;
    }

    public abstract String getColumnDefinition();

    public abstract int getLength();

    public final AbstractLocator getLocator() {
        return this.locator;
    }

    public abstract Mapping<?, ?, ?> getMapping();

    public abstract String getName();

    public abstract int getPrecision();

    public abstract int getScale();

    public abstract int getSqlType();

    public abstract AbstractTable getTable();

    public abstract String getTableName();

    public abstract Object getValue(Connection var1, Object var2);

    public abstract boolean isInsertable();

    public boolean isLob() {
        return this.lob;
    }

    public abstract boolean isNullable();

    public boolean isPrimaryKey() {
        return false;
    }

    public abstract boolean isUnique();

    public abstract boolean isUpdatable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readLob(Object value) {
        try {
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                if (this.javaType == String.class) {
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)clob.getAsciiStream(), (Writer)w);
                    return w.toString();
                }
                CharArrayWriter w = new CharArrayWriter((int)clob.length());
                IOUtils.copy((Reader)clob.getCharacterStream(), (Writer)w);
                return w.toCharArray();
            }
            if (value instanceof byte[]) {
                if (this.javaType == String.class) {
                    StringWriter w = new StringWriter();
                    IOUtils.copy((InputStream)new ByteArrayInputStream((byte[])value), (Writer)w);
                    return w.toString();
                }
                if (this.javaType == char[].class) {
                    byte[] byteArray = (byte[])value;
                    char[] charArray = new char[byteArray.length];
                    int i = 0;
                    while (true) {
                        if (i >= charArray.length) {
                            return charArray;
                        }
                        charArray[i] = (char)byteArray[i];
                        ++i;
                    }
                }
                if (this.javaType == byte[].class) return value;
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                try {
                    Object charArray = is.readObject();
                    return charArray;
                }
                finally {
                    is.close();
                }
            }
            if (value instanceof String) {
                return value;
            }
            Blob blob = (Blob)value;
            if (this.javaType == byte[].class) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)blob.getBinaryStream(), (OutputStream)os);
                return os.toByteArray();
            }
            ObjectInputStream is = new ObjectInputStream(blob.getBinaryStream());
            try {
                value = is.readObject();
                return value;
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot read sql data", (Throwable)e);
        }
    }

    public abstract void setTable(AbstractTable var1);

    public abstract void setValue(Object var1, Object var2);

    public String toString() {
        String tableName = this.getTable() != null ? this.getTable().getName() : "N/A";
        String mapping = this.getMapping() != null ? " " + this.getMapping().toString() + " " : "";
        return this.getClass().getSimpleName() + mapping + " [name=" + this.getName() + ", type=" + this.getSqlType() + ", length=" + this.getLength() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", table=" + tableName + "]";
    }
}

