/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.batoo.jpa.core.jdbc.adapter.DerbyAdaptor;
import org.batoo.jpa.core.jdbc.adapter.H2Adaptor;
import org.batoo.jpa.core.jdbc.adapter.HsqlAdaptor;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.core.jdbc.adapter.MsSqlAdaptor;
import org.batoo.jpa.core.jdbc.adapter.MySqlAdaptor;
import org.batoo.jpa.core.jdbc.adapter.OracleAdaptor;
import org.batoo.jpa.core.jdbc.adapter.PostgreSqlAdaptor;
import org.batoo.jpa.core.jdbc.adapter.SawSqlAdaptor;

public abstract class AbstractJdbcAdaptor {
    private static final Map<String, JdbcAdaptor> ADAPTERS = AbstractJdbcAdaptor.prepareAdaptors();

    public static JdbcAdaptor getAdapter(ClassLoader classloader, String databaseProductName) {
        JdbcAdaptor jdbcAdaptor = ADAPTERS.get(databaseProductName);
        if (jdbcAdaptor == null) {
            throw new PersistenceException("Cannot locate JDBC Adaptor for '" + databaseProductName + "'");
        }
        try {
            return (JdbcAdaptor)jdbcAdaptor.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Map<String, JdbcAdaptor> prepareAdaptors() {
        HashMap adaptors = Maps.newHashMap();
        AbstractJdbcAdaptor.putAdaptor(adaptors, new DerbyAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new MySqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new MsSqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new OracleAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new H2Adaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new HsqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new PostgreSqlAdaptor());
        AbstractJdbcAdaptor.putAdaptor(adaptors, new SawSqlAdaptor());
        return adaptors;
    }

    private static void putAdaptor(Map<String, JdbcAdaptor> adaptors, JdbcAdaptor adaptor) {
        for (String productName : adaptor.getProductNames()) {
            adaptors.put(productName, adaptor);
        }
    }

    protected abstract String[] getProductNames();
}

