/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.sql.Connection;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.CollectionTable;
import org.batoo.jpa.core.impl.jdbc.TypeFactory;
import org.batoo.jpa.core.impl.model.mapping.ElementCollectionMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class ElementColumn
extends AbstractColumn {
    private final ElementCollectionMapping<?, ?, ?> mapping;
    private final CollectionTable table;
    private final int sqlType;
    private final String columnDefinition;
    private final String name;
    private final boolean insertable;
    private final boolean nullable;
    private final boolean updatable;
    private final int length;
    private final int precision;
    private final int scale;
    private final boolean unique;

    public ElementColumn(JdbcAdaptor jdbcAdaptor, ElementCollectionMapping<?, ?, ?> mapping, CollectionTable table, String name, Class<?> javaType, EnumType enumType, TemporalType temporalType, boolean lob, ColumnMetadata metadata) {
        super(javaType, temporalType, enumType, lob, metadata != null ? metadata.getLocator() : null);
        this.mapping = mapping;
        this.table = table;
        this.sqlType = TypeFactory.getSqlType(javaType, temporalType, enumType, lob);
        this.name = jdbcAdaptor.escape(name);
        this.columnDefinition = metadata != null ? metadata.getColumnDefinition() : null;
        this.length = metadata != null ? metadata.getLength() : 255;
        this.precision = metadata != null ? metadata.getPrecision() : 0;
        this.scale = metadata != null ? metadata.getScale() : 0;
        this.insertable = metadata != null ? metadata.isInsertable() : true;
        this.nullable = metadata != null ? metadata.isNullable() : true;
        this.unique = metadata != null ? metadata.isUnique() : false;
        this.updatable = metadata != null ? metadata.isUpdatable() : true;
        this.table.addColumn(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getValue(Connection connection, Object value) {
        return this.convertValue(connection, value);
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public void setTable(AbstractTable table) {
    }

    @Override
    public void setValue(Object instance, Object value) {
        this.mapping.set(instance, this.convertValueForSet(value));
    }
}

