/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.BasicColumn;
import org.batoo.jpa.core.impl.jdbc.DiscriminatorColumn;
import org.batoo.jpa.core.impl.jdbc.JoinColumn;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.core.impl.jdbc.dbutils.SingleValueHandler;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.IdType;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.TableMetadata;

public class EntityTable
extends AbstractTable {
    private final EntityTypeImpl<?> entity;
    private final Map<String, AbstractColumn> pkColumns = Maps.newHashMap();
    private final JdbcAdaptor jdbcAdaptor;
    private PkColumn identityColumn;
    private final Map<String, BasicColumn[]> indexes = Maps.newHashMap();
    private final HashMap<Integer, String> removeSqlMap = Maps.newHashMap();
    private AbstractColumn[] removeColumns;

    public EntityTable(EntityTypeImpl<?> entity, TableMetadata metadata) {
        super(entity.getName(), metadata);
        this.entity = entity;
        this.jdbcAdaptor = entity.getMetamodel().getJdbcAdaptor();
    }

    @Override
    public void addColumn(AbstractColumn column) {
        JoinColumn joinColumn;
        super.addColumn(column);
        if (column instanceof PkColumn) {
            PkColumn pkColumn = (PkColumn)column;
            this.pkColumns.put(pkColumn.getName(), pkColumn);
            if (pkColumn.getIdType() == IdType.IDENTITY) {
                this.identityColumn = (PkColumn)column;
            }
        } else if (column instanceof JoinColumn && (joinColumn = (JoinColumn)column).isPrimaryKey()) {
            this.pkColumns.put(column.getName(), joinColumn);
        }
    }

    public boolean addIndex(String name, BasicColumn ... columns) {
        if (this.indexes.containsKey(name)) {
            return true;
        }
        this.indexes.put(name, columns);
        return false;
    }

    public EntityTypeImpl<?> getEntity() {
        return this.entity;
    }

    public Map<String, BasicColumn[]> getIndexes() {
        return this.indexes;
    }

    protected JdbcAdaptor getJdbcAdaptor() {
        return this.jdbcAdaptor;
    }

    @Override
    public Set<String> getPkColumnNames() {
        return this.pkColumns.keySet();
    }

    public Collection<AbstractColumn> getPkColumns() {
        return this.pkColumns.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql(int size) {
        String sql = this.removeSqlMap.get(size);
        if (sql != null) {
            return sql;
        }
        EntityTable entityTable = this;
        synchronized (entityTable) {
            String restriction;
            sql = this.removeSqlMap.get(size);
            if (sql != null) {
                return sql;
            }
            this.removeColumns = new AbstractColumn[this.pkColumns.size()];
            this.pkColumns.values().toArray(this.removeColumns);
            if (this.pkColumns.size() > 1) {
                Collection restrictions = Collections2.transform(this.pkColumns.values(), (Function)new Function<AbstractColumn, String>(){

                    public String apply(AbstractColumn input) {
                        return input.getName() + " = ?";
                    }
                });
                String singleRestriction = Joiner.on((String)" AND ").join((Iterable)restrictions);
                restriction = StringUtils.repeat((String)singleRestriction, (String)" OR ", (int)size);
            } else {
                restriction = size == 1 ? this.removeColumns[0].getName() + " = ?" : this.removeColumns[0].getName() + " IN (" + StringUtils.repeat((String)"?", (String)", ", (int)size) + ")";
            }
            sql = "DELETE FROM " + this.getQName() + " WHERE " + restriction;
            this.removeSqlMap.put(size, sql);
            return sql;
        }
    }

    public void performInsert(Connection connection, ManagedInstance<?>[] managedInstances, int size) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstances[0].getType();
        String insertSql = this.getInsertSql(entityType, size);
        AbstractColumn[] insertColumns = this.getInsertColumns(entityType, size);
        Object[] params = new Object[insertColumns.length * size];
        boolean hasLob = false;
        for (int i = 0; i < size; ++i) {
            ManagedInstance<?> managedInstance = managedInstances[i];
            Object instance = managedInstance.getInstance();
            for (int j = 0; j < insertColumns.length; ++j) {
                AbstractColumn column = insertColumns[j];
                params[i * insertColumns.length + j] = column instanceof DiscriminatorColumn ? entityType.getDiscriminatorValue() : column.getValue(connection, instance);
                hasLob |= column.isLob();
            }
            managedInstance.setStatus(Status.MANAGED);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken(), hasLob).update(connection, insertSql, params);
        if (this.identityColumn != null) {
            String selectLastIdSql = this.jdbcAdaptor.getSelectLastIdentitySql(this.identityColumn);
            Number id = (Number)new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false).query(connection, selectLastIdSql, new SingleValueHandler());
            this.identityColumn.setValue(managedInstances[0].getInstance(), id);
        }
    }

    public void performRemove(Connection connection, ManagedInstance<?>[] managedInstances, int size) throws SQLException {
        String removeSql = this.getRemoveSql(size);
        Object[] params = new Object[size * this.removeColumns.length];
        for (int i = 0; i < size; ++i) {
            Object instance = managedInstances[i].getInstance();
            for (int j = 0; j < this.removeColumns.length; ++j) {
                AbstractColumn column = this.removeColumns[j];
                params[i * this.removeColumns.length + j] = column.getValue(connection, instance);
            }
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false);
        runner.update(connection, removeSql, params);
    }

    public Object performSelectVersion(Connection connection, ManagedInstance<?> managedInstance) throws SQLException {
        Object instance = managedInstance.getInstance();
        String updateSql = this.getSelectVersionSql(this.pkColumns);
        AbstractColumn[] selectVersionColumns = this.getSelectVersionColumns();
        Object[] params = new Object[selectVersionColumns.length];
        for (int i = 0; i < selectVersionColumns.length; ++i) {
            AbstractColumn column = selectVersionColumns[i];
            params[i] = column.getValue(connection, instance);
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false);
        return runner.query(connection, updateSql, new SingleValueHandler(), params);
    }

    public void performUpdate(Connection connection, ManagedInstance<?> managedInstance) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        String updateSql = this.getUpdateSql(entityType, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(entityType);
        boolean hasLob = false;
        Object[] params = new Object[updateColumns.length];
        for (int i = 0; i < updateColumns.length; ++i) {
            AbstractColumn column = updateColumns[i];
            params[i] = column.getValue(connection, instance);
            hasLob |= column.isLob();
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken(), hasLob);
        runner.update(connection, updateSql, params);
    }

    public boolean performUpdateWithUpdatability(Connection connection, ManagedInstance<?> managedInstance) throws SQLException {
        EntityTypeImpl<?> entityType = managedInstance.getType();
        Object instance = managedInstance.getInstance();
        String updateSql = this.getUpdateSql(entityType, this.pkColumns);
        AbstractColumn[] updateColumns = this.getUpdateColumns(entityType);
        boolean hasLob = false;
        Object[] params = new Object[updateColumns.length];
        for (int i = 0; i < updateColumns.length; ++i) {
            AbstractColumn column = updateColumns[i];
            if (i == 0 && column.isPrimaryKey()) {
                return false;
            }
            params[i] = column.getValue(connection, instance);
            hasLob |= column.isLob();
        }
        QueryRunner runner = new QueryRunner(this.jdbcAdaptor.isPmdBroken(), hasLob);
        runner.update(connection, updateSql, params);
        return true;
    }

    public void performVersionUpdate(Connection connection, ManagedInstance<?> managedInstance) throws SQLException {
        Object instance = managedInstance.getInstance();
        String updateSql = this.getVersionUpdateSql(this.pkColumns);
        AbstractColumn[] versionUpdateColumns = this.getVersionUpdateColumns();
        Object[] params = new Object[versionUpdateColumns.length];
        for (int i = 0; i < versionUpdateColumns.length; ++i) {
            AbstractColumn column = versionUpdateColumns[i];
            params[i] = column.getValue(connection, instance);
        }
        new QueryRunner(this.jdbcAdaptor.isPmdBroken(), false).update(connection, updateSql, params);
    }

    public String toString() {
        String columns = Joiner.on((String)", ").join((Iterable)Collections2.transform(this.getColumns(), (Function)new Function<AbstractColumn, String>(){

            public String apply(AbstractColumn input) {
                StringBuffer out = new StringBuffer();
                out.append(input instanceof PkColumn ? "ID [" : "COL [");
                out.append("name=");
                out.append(input.getName());
                out.append(", type=");
                out.append(input.getSqlType());
                out.append("]");
                return out.toString();
            }
        }));
        return "Table [owner=" + this.entity.getName() + ", name=" + this.getQName() + ", columns=[" + columns + "]]";
    }
}

