/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc;

import java.sql.Connection;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.jdbc.AbstractColumn;
import org.batoo.jpa.core.impl.jdbc.AbstractTable;
import org.batoo.jpa.core.impl.jdbc.EntityTable;
import org.batoo.jpa.core.impl.jdbc.PkColumn;
import org.batoo.jpa.core.impl.jdbc.SecondaryTable;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;

public class JoinColumn
extends AbstractColumn {
    private final JdbcAdaptor jdbcAdaptor;
    private AbstractTable table;
    private final boolean primaryKey;
    private String name;
    private String referencedColumnName;
    private final String columnDefinition;
    private final String tableName;
    private final boolean insertable;
    private final boolean nullable;
    private final boolean unique;
    private final boolean updatable;
    private int length;
    private int precision;
    private int sqlType;
    private int scale;
    private AssociationMapping<?, ?, ?> mapping;
    private BasicMapping<?, ?> referencedMapping;

    public JoinColumn(JdbcAdaptor jdbcAdaptor, AssociationMapping<?, ?, ?> mapping, BasicMapping<?, ?> idMapping) {
        super(null);
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.primaryKey = false;
        this.columnDefinition = "";
        this.tableName = "";
        this.insertable = true;
        this.nullable = true;
        this.unique = false;
        this.updatable = true;
        this.setColumnProperties(mapping, idMapping);
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, EntityTable table, BasicMapping<?, ?> idMapping) {
        super(null);
        this.jdbcAdaptor = jdbcAdaptor;
        this.referencedMapping = idMapping;
        this.primaryKey = false;
        PkColumn referencedColumn = (PkColumn)idMapping.getColumn();
        this.referencedColumnName = referencedColumn.getName();
        this.columnDefinition = referencedColumn.getColumnDefinition();
        this.tableName = table.getName();
        this.name = referencedColumn.getName();
        this.insertable = referencedColumn.isInsertable();
        this.nullable = referencedColumn.isNullable();
        this.unique = referencedColumn.isUnique();
        this.updatable = referencedColumn.isUnique();
        this.setColumnProperties(idMapping);
        this.setTable(table);
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, JoinColumnMetadata metadata) {
        super(metadata.getLocator());
        this.jdbcAdaptor = jdbcAdaptor;
        this.primaryKey = false;
        this.referencedColumnName = metadata.getReferencedColumnName();
        this.columnDefinition = metadata.getColumnDefinition();
        this.tableName = metadata.getTable();
        this.name = metadata.getName();
        this.insertable = metadata.isInsertable();
        this.nullable = metadata.isNullable();
        this.unique = metadata.isUnique();
        this.updatable = metadata.isUpdatable();
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, PrimaryKeyJoinColumnMetadata metadata, SecondaryTable table, BasicMapping<?, ?> idMapping) {
        super(metadata.getLocator());
        this.jdbcAdaptor = jdbcAdaptor;
        this.tableName = table.getName();
        this.primaryKey = false;
        this.referencedColumnName = metadata.getReferencedColumnName();
        this.columnDefinition = metadata.getColumnDefinition();
        this.name = jdbcAdaptor.escape(metadata.getName());
        this.insertable = true;
        this.nullable = false;
        this.unique = false;
        this.updatable = false;
        this.setColumnProperties(idMapping);
        this.setTable(table);
    }

    public JoinColumn(JdbcAdaptor jdbcAdaptor, SecondaryTable table, BasicMapping<?, ?> idMapping) {
        super(null);
        this.jdbcAdaptor = jdbcAdaptor;
        this.referencedMapping = idMapping;
        this.primaryKey = true;
        PkColumn referencedColumn = (PkColumn)idMapping.getColumn();
        this.referencedColumnName = referencedColumn.getName();
        this.columnDefinition = referencedColumn.getColumnDefinition();
        this.tableName = table.getName();
        this.name = referencedColumn.getName();
        this.insertable = referencedColumn.isInsertable();
        this.nullable = referencedColumn.isNullable();
        this.unique = referencedColumn.isUnique();
        this.updatable = referencedColumn.isUnique();
        this.setColumnProperties(idMapping);
        this.setTable(table);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Mapping<?, ?, ?> getMapping() {
        return this.mapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public BasicMapping<?, ?> getReferencedMapping() {
        return this.referencedMapping;
    }

    public AbstractTable getReferencedTable() {
        return this.referencedMapping.getColumn().getTable();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public AbstractTable getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getValue(Connection connection, Object instance) {
        if (this.mapping != null) {
            instance = this.mapping.get(instance);
        }
        return instance != null ? this.referencedMapping.get(instance) : null;
    }

    @Override
    public boolean isInsertable() {
        return this.insertable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setColumnProperties(AssociationMapping<?, ?, ?> mapping, BasicMapping<?, ?> referencedMapping) {
        if (mapping != null) {
            this.mapping = mapping;
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(mapping.getName() + "_" + referencedMapping.getColumn().getName());
            }
        } else {
            EntityTypeImpl type = (EntityTypeImpl)referencedMapping.getRoot().getType();
            if (StringUtils.isBlank((String)this.name)) {
                this.name = this.jdbcAdaptor.escape(type.getName() + "_" + referencedMapping.getColumn().getName());
            }
        }
        this.setColumnProperties(referencedMapping);
    }

    private void setColumnProperties(BasicMapping<?, ?> referencedMapping) {
        this.referencedMapping = referencedMapping;
        PkColumn referencedColumn = (PkColumn)referencedMapping.getColumn();
        this.referencedColumnName = referencedColumn.getName();
        this.sqlType = referencedColumn.getSqlType();
        this.length = referencedColumn.getLength();
        this.precision = referencedColumn.getPrecision();
        this.scale = referencedColumn.getScale();
    }

    @Override
    public void setTable(AbstractTable table) {
        this.table = table;
        this.table.addColumn(this);
    }

    @Override
    public void setValue(Object instance, Object value) {
        if (this.mapping != null) {
            this.mapping.set(instance, value);
        }
    }
}

