/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.jdbc.dbutils;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.batoo.jpa.core.impl.jdbc.PreparedStatementProxy;

public class QueryRunner {
    private final boolean hasLob;
    private final DataSource datasource;
    private boolean pmdKnownBroken = false;
    private ParameterMetaData pmd;

    public QueryRunner() {
        this.hasLob = false;
        this.datasource = null;
    }

    public QueryRunner(boolean pmdKnownBroken, boolean hasLob) {
        this.pmdKnownBroken = pmdKnownBroken;
        this.hasLob = hasLob;
        this.datasource = null;
    }

    public QueryRunner(DataSource datasource) {
        this.hasLob = false;
        this.datasource = datasource;
    }

    public QueryRunner(DataSource datasource, boolean pmdKnownBroken) {
        this.hasLob = false;
        this.datasource = datasource;
    }

    private SQLException convertSqlException(SQLException cause, String sql, Object ... params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        return e;
    }

    private void fillStatement(PreparedStatement statement, Object ... params) throws SQLException {
        if (this.pmdKnownBroken) {
            ((PreparedStatementProxy)statement).setParamCount(params.length);
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param != null) {
                if (this.hasLob && param instanceof Clob) {
                    statement.setClob(i + 1, (Clob)param);
                    continue;
                }
                if (this.hasLob && param instanceof Blob) {
                    statement.setBlob(i + 1, (Blob)param);
                    continue;
                }
                statement.setObject(i + 1, param);
                continue;
            }
            if (!this.pmdKnownBroken && this.pmd == null) {
                this.pmd = statement.getParameterMetaData();
            }
            int sqlType = 12;
            if (!this.pmdKnownBroken) {
                try {
                    sqlType = this.pmd.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    this.pmdKnownBroken = true;
                }
            }
            statement.setNull(i + 1, sqlType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Object object;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(sql);
            if (params != null) {
                this.fillStatement(statement, params);
            }
            resultSet = statement.executeQuery();
            object = rsh.handle(resultSet);
        }
        catch (SQLException e) {
            try {
                throw this.convertSqlException(e, sql, params);
            }
            catch (Throwable throwable) {
                try {
                    DbUtils.close(resultSet);
                    throw throwable;
                }
                finally {
                    DbUtils.close((Statement)statement);
                    if (closeConn) {
                        DbUtils.close((Connection)conn);
                    }
                }
            }
        }
        try {
            DbUtils.close((ResultSet)resultSet);
            return (T)object;
        }
        finally {
            DbUtils.close((Statement)statement);
            if (closeConn) {
                DbUtils.close((Connection)conn);
            }
        }
    }

    public <T> T query(Connection connection, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(connection, false, sql, rsh, (Object[])null);
    }

    public <T> T query(Connection connection, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.query(connection, false, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(this.datasource.getConnection(), true, sql, rsh, (Object[])null);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.query(this.datasource.getConnection(), true, sql, rsh, params);
    }

    private int update(Connection connection, boolean closeConn, String sql, Object ... params) throws SQLException {
        if (connection == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                DbUtils.close((Connection)connection);
            }
            throw new SQLException("Null SQL statement");
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            if (params != null) {
                this.fillStatement(statement, params);
            }
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw this.convertSqlException(e, sql, params);
        }
        finally {
            DbUtils.close((Statement)statement);
            if (closeConn) {
                DbUtils.close((Connection)connection);
            }
        }
    }

    public int update(Connection connection, String sql) throws SQLException {
        return this.update(connection, false, sql, (Object[])null);
    }

    public int update(Connection connection, String sql, Object ... params) throws SQLException {
        return this.update(connection, false, sql, params);
    }

    public int update(String sql) throws SQLException {
        return this.update(this.datasource.getConnection(), true, sql, (Object[])null);
    }

    public int update(String sql, Object ... params) throws SQLException {
        return this.update(this.datasource.getConnection(), true, sql, params);
    }
}

