/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import java.util.Collections;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.PersistenceException;
import javax.transaction.TransactionManager;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.JtaEntityManagerImpl;
import org.batoo.jpa.parser.PersistenceParser;

public class JtaEntityManagerFactoryImpl
extends EntityManagerFactoryImpl {
    private static final BLogger LOG = BLoggerFactory.getLogger(JtaEntityManagerFactoryImpl.class);
    private static final String[] TRANSACTION_MANAGERS = new String[]{"java:appserver/TransactionManager", "java:/TransactionManager", "java:jboss/TransactionManager", "java:comp/pm/TransactionManager", "TransactionManager", "java:appserver/TransactionManager"};
    private final TransactionManager transactionManager = this.lookupTransactionManager();

    public JtaEntityManagerFactoryImpl(String name, PersistenceParser parser) {
        super(name, parser);
    }

    @Override
    public EntityManagerImpl createEntityManager() {
        this.assertOpen();
        return new JtaEntityManagerImpl(this, this.getMetamodel(), this.getDatasource(), Collections.<String, Object>emptyMap(), this.getJdbcAdaptor());
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private TransactionManager lookupTransactionManager() {
        for (String jndiName : TRANSACTION_MANAGERS) {
            TransactionManager manager = this.lookupTransactionManager(jndiName);
            if (manager == null) continue;
            LOG.info("Using JTA Transaction manager: {0}", jndiName);
            return manager;
        }
        throw new PersistenceException("Unable to locate the transa ction manager");
    }

    private TransactionManager lookupTransactionManager(String jndiName) {
        try {
            LOG.debug("Trying JTA Transaction Manager: {0}", jndiName);
            return (TransactionManager)new InitialContext().lookup(jndiName);
        }
        catch (NamingException namingException) {
            return null;
        }
    }
}

