/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.manager;

import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.EntityTransactionImpl;
import org.batoo.jpa.core.impl.manager.JtaEntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.jdbc.adapter.JdbcAdaptor;

public class JtaEntityManagerImpl
extends EntityManagerImpl {
    private Transaction jtaTransaction;
    private final JtaEntityManagerFactoryImpl emf;

    public JtaEntityManagerImpl(JtaEntityManagerFactoryImpl entityManagerFactory, MetamodelImpl metamodel, DataSource datasource, Map<String, Object> properties, JdbcAdaptor jdbcAdaptor) {
        super(entityManagerFactory, metamodel, datasource, properties, jdbcAdaptor);
        this.emf = entityManagerFactory;
    }

    @Override
    public void assertTransaction() {
        this.assertOpen();
        this.joinTransaction();
        if (this.jtaTransaction == null) {
            throw new TransactionRequiredException("No active transaction");
        }
    }

    @Override
    protected void closeConnection() {
        super.closeConnection();
        this.jtaTransaction = null;
    }

    @Override
    public void closeConnectionIfNecessary() {
        if (this.jtaTransaction == null) {
            this.closeConnection();
        }
    }

    @Override
    public EntityTransactionImpl getTransaction() {
        throw new PersistenceException("Transactions are configured as container managed");
    }

    @Override
    public boolean hasTransactionMarkedForRollback() {
        if (this.jtaTransaction != null) {
            try {
                return this.jtaTransaction.getStatus() == 1;
            }
            catch (SystemException e) {
                throw new PersistenceException("Cannot check transaction status", (Throwable)e);
            }
        }
        return super.hasTransactionMarkedForRollback();
    }

    @Override
    public boolean isJoinedToTransaction() {
        return this.jtaTransaction != null;
    }

    @Override
    public void joinTransaction() {
        if (this.jtaTransaction != null) {
            return;
        }
        this.assertOpen();
        try {
            this.jtaTransaction = this.emf.getTransactionManager().getTransaction();
            if (this.jtaTransaction != null) {
                this.jtaTransaction.registerSynchronization(new Synchronization(){

                    public void afterCompletion(int status) {
                        JtaEntityManagerImpl.this.closeConnection();
                    }

                    public void beforeCompletion() {
                        JtaEntityManagerImpl.this.flush();
                    }
                });
            }
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to join JTA");
        }
    }
}

