/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.criteria.join.AbstractFrom;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinTable;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.MappableAssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.OrphanableAssociationAttributeMetadata;
import org.batoo.jpa.util.BatooUtils;

public abstract class AssociationMapping<Z, X, Y>
extends Mapping<Z, X, Y>
implements JoinedMapping<Z, X, Y> {
    private final boolean eager;
    private final boolean cascadesDetach;
    private final boolean cascadesMerge;
    private final boolean cascadesPersist;
    private final boolean cascadesRefresh;
    private final boolean cascadesRemove;
    private final String mappedBy;
    private final boolean removesOrphans;
    private final int maxFetchDepth;
    private CriteriaQueryImpl<Y> selectCriteria;

    public AssociationMapping(ParentMapping<?, Z> parent, AssociationAttributeMetadata metadata, AttributeImpl<? super Z, X> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        this.mappedBy = metadata instanceof MappableAssociationAttributeMetadata && StringUtils.isNotBlank((String)((MappableAssociationAttributeMetadata)((Object)metadata)).getMappedBy()) ? ((MappableAssociationAttributeMetadata)((Object)metadata)).getMappedBy() : null;
        this.eager = attribute.isCollection() || this.mappedBy == null ? metadata.getFetchType() == FetchType.EAGER : true;
        this.maxFetchDepth = metadata.getMaxFetchDepth();
        this.removesOrphans = metadata instanceof OrphanableAssociationAttributeMetadata ? ((OrphanableAssociationAttributeMetadata)((Object)metadata)).removesOrphans() : false;
        this.cascadesDetach = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.DETACH);
        this.cascadesMerge = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.MERGE);
        this.cascadesPersist = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.PERSIST);
        this.cascadesRefresh = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.REFRESH);
        this.cascadesRemove = metadata.getCascades().contains(CascadeType.ALL) || metadata.getCascades().contains(CascadeType.REMOVE);
    }

    public final boolean cascadesDetach() {
        return this.cascadesDetach;
    }

    public final boolean cascadesMerge() {
        return this.cascadesMerge;
    }

    public final boolean cascadesPersist() {
        return this.cascadesPersist;
    }

    public final boolean cascadesRefresh() {
        return this.cascadesRefresh;
    }

    public final boolean cascadesRemove() {
        return this.cascadesRemove;
    }

    public abstract void checkTransient(ManagedInstance<?> var1);

    protected AssociationMetadata getAssociationMetadata() {
        AssociationMetadata metadata = null;
        String path = this.getParent().getRootPath(this.getAttribute().getName());
        AttributeImpl rootAttribute = this.getParent().getRootAttribute(this.getAttribute());
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMapping && (metadata = ((EmbeddedMapping)this.getParent()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() instanceof MappedSuperclassTypeImpl && (metadata = ((EntityTypeImpl)this.getRoot().getType()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        if (this.getParent() instanceof EmbeddedMapping && (metadata = ((EmbeddedMapping)this.getParent()).getAssociationOverride(path)) != null) {
            return metadata;
        }
        return (AssociationMetadata)((Object)this.getAttribute().getMetadata());
    }

    public abstract ForeignKey getForeignKey();

    public abstract AssociationMapping<?, ?, ?> getInverse();

    public String getMappedBy() {
        return this.mappedBy;
    }

    public int getMaxFetchJoinDepth() {
        return this.maxFetchDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CriteriaQueryImpl<Y> getSelectCriteria() {
        if (this.selectCriteria != null) {
            return this.selectCriteria;
        }
        AssociationMapping associationMapping = this;
        synchronized (associationMapping) {
            if (this.selectCriteria != null) {
                return this.selectCriteria;
            }
            MetamodelImpl metamodel = this.getRoot().getType().getMetamodel();
            CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
            AttributeImpl attribute = this.getAttribute();
            Class<Object> bindableType = attribute instanceof PluralAttributeImpl ? ((PluralAttributeImpl)attribute).getBindableJavaType() : ((SingularAttributeImpl)attribute).getBindableJavaType();
            EntityType entity = metamodel.entity(bindableType);
            Object q = cb.createQuery((Class)bindableType);
            ((AbstractCriteriaQueryImpl)q).internal();
            EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
            Root r = ((AbstractCriteriaQueryImpl)q).from(type);
            r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
            Iterator pathIterator = Splitter.on((String)".").split((CharSequence)this.getPath()).iterator();
            pathIterator.next();
            AbstractFrom join = null;
            while (pathIterator.hasNext()) {
                join = join == null ? r.join((String)pathIterator.next()) : join.join((String)pathIterator.next());
            }
            q = ((CriteriaQueryImpl)q).select(join);
            entity.prepareEagerJoins((FetchParent<?, ?>)join, 0, this);
            if (type.hasSingleIdAttribute()) {
                SingularMapping idMapping = type.getIdMapping();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get(idMapping.getAttribute().getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                this.selectCriteria = ((CriteriaQueryImpl)q).where((Expression)predicate);
                return this.selectCriteria;
            }
            ArrayList predicates = Lists.newArrayList();
            for (Pair pair : type.getIdMappings()) {
                BasicMapping idMapping = pair.getFirst();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get(idMapping.getAttribute().getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                predicates.add(predicate);
            }
            this.selectCriteria = ((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()]));
            return this.selectCriteria;
        }
    }

    @Override
    public abstract JoinTable getTable();

    @Override
    public abstract EntityTypeImpl<Y> getType();

    @Override
    public final boolean isEager() {
        return this.eager;
    }

    public final boolean isOwner() {
        return this.mappedBy == null;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        if (this.getForeignKey() != null) {
            return this.getForeignKey().createDestinationJoin(joinType, parentAlias, alias);
        }
        if (this.getInverse() != null && this.getInverse().getForeignKey() != null) {
            return this.getInverse().getForeignKey().createSourceJoin(joinType, parentAlias, alias);
        }
        if (this.getTable() != null) {
            return this.getTable().createJoin(joinType, parentAlias, alias, true);
        }
        return this.getInverse().getTable().createJoin(joinType, parentAlias, alias, false);
    }

    public abstract void link() throws MappingException;

    public abstract void mergeWith(EntityManagerImpl var1, ManagedInstance<?> var2, Object var3, MutableBoolean var4, IdentityHashMap<Object, Object> var5);

    public abstract boolean references(Object var1, Object var2);

    public abstract void refresh(ManagedInstance<?> var1, Set<Object> var2);

    public boolean removesOrphans() {
        return this.removesOrphans;
    }

    public abstract void setInverse(AssociationMapping<?, ?, ?> var1);
}

