/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.ManagedList;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.criteria.join.MapJoinImpl;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.CollectionTable;
import org.batoo.jpa.core.impl.jdbc.Joinable;
import org.batoo.jpa.core.impl.jdbc.JoinableTable;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.ElementMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.ListComparator;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.ElementCollectionAttributeMetadata;
import org.batoo.jpa.util.BatooUtils;
import org.batoo.jpa.util.FinalWrapper;

public class ElementCollectionMapping<Z, C, E>
extends Mapping<Z, C, E>
implements PluralMapping<Z, C, E> {
    private final PluralAttributeImpl<? super Z, C, E> attribute;
    private final boolean eager;
    private final CollectionTable collectionTable;
    private final ColumnMetadata column;
    private final EnumType enumType;
    private final boolean lob;
    private final TemporalType temporalType;
    private final String orderBy;
    private final ColumnMetadata orderColumn;
    private final ColumnMetadata mapKeyColumn;
    private final String mapKey;
    private final EnumType mapKeyEnumType;
    private final TemporalType mapKeyTemporalType;
    private TypeImpl<E> type;
    private SingularMapping<? super E, ?> keyMapping;
    private ElementMapping<E> rootMapping;
    private FinalWrapper<Comparator<E>> comparator;
    private FinalWrapper<CriteriaQueryImpl<E>> selectCriteria;
    private FinalWrapper<CriteriaQueryImpl<Object[]>> selectMapCriteria;

    public ElementCollectionMapping(ParentMapping<?, Z> parent, PluralAttributeImpl<? super Z, C, E> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        ElementCollectionAttributeMetadata metadata = (ElementCollectionAttributeMetadata)attribute.getMetadata();
        this.attribute = attribute;
        this.eager = metadata.getFetchType() == FetchType.EAGER;
        this.collectionTable = new CollectionTable((EntityTypeImpl)this.getRoot().getType(), metadata.getCollectionTable());
        this.column = metadata.getColumn();
        this.enumType = metadata.getEnumType();
        this.lob = metadata.isLob();
        this.temporalType = metadata.getTemporalType();
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            this.orderColumn = metadata.getOrderColumn();
            this.orderBy = metadata.getOrderBy();
        } else {
            this.orderBy = null;
            this.orderColumn = null;
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            this.mapKeyColumn = metadata.getMapKeyColumn();
            this.mapKeyTemporalType = metadata.getMapKeyTemporalType();
            this.mapKeyEnumType = metadata.getMapKeyEnumType();
            this.mapKey = metadata.getMapKey();
        } else {
            this.mapKeyColumn = null;
            this.mapKeyTemporalType = null;
            this.mapKeyEnumType = null;
            this.mapKey = null;
        }
    }

    @Override
    public void attach(Connection connection, ManagedInstance<?> instance, Joinable[] batch, int size) throws SQLException {
        this.collectionTable.performInsert(connection, instance.getInstance(), batch, size);
    }

    @Override
    public boolean cascadesMerge() {
        return false;
    }

    @Override
    public void detach(Connection connection, ManagedInstance<?> instance, Object key, Object child) throws SQLException {
        this.collectionTable.performRemove(connection, instance.getInstance(), key, child);
    }

    @Override
    public void detachAll(Connection connection, ManagedInstance<?> instance) throws SQLException {
        this.collectionTable.performRemoveAll(connection, instance.getInstance());
    }

    @Override
    public void enhance(ManagedInstance<?> instance) {
        Object c = this.get(instance.getInstance());
        if (c == null) {
            this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false));
        } else {
            this.set(instance.getInstance(), this.attribute.newCollection(this, instance, c));
        }
    }

    @Override
    public Object extractKey(Object value) {
        return this.keyMapping.get(value);
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        Object collection = this.get(managedInstance.getInstance());
        if (collection != null) {
            ((ManagedCollection)collection).flush(connection, removals, force);
        }
    }

    public PluralAttributeImpl<? super Z, C, E> getAttribute() {
        return this.attribute;
    }

    public CollectionTable getCollectionTable() {
        return this.collectionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<E> getComparator() {
        FinalWrapper<Comparator<E>> wrapper = this.comparator;
        if (wrapper == null) {
            ElementCollectionMapping elementCollectionMapping = this;
            synchronized (elementCollectionMapping) {
                if (this.comparator == null) {
                    this.comparator = new FinalWrapper(new ListComparator(this));
                }
                wrapper = this.comparator;
            }
        }
        return (Comparator)wrapper.value;
    }

    public SingularMapping<? super E, ?> getKeyMapping() {
        return this.keyMapping;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public TypeImpl<?> getMapKeyClass() {
        return null;
    }

    @Override
    public Mapping<?, ?, ?> getMapping(String path) {
        return this.rootMapping.getMapping(path);
    }

    @Override
    public JoinedMapping.MappingType getMappingType() {
        return JoinedMapping.MappingType.ELEMENT_COLLECTION;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OrderColumn getOrderColumn() {
        if (this.collectionTable != null) {
            return this.collectionTable.getOrderColumn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<E> getSelectCriteria() {
        FinalWrapper<CriteriaQueryImpl<E>> wrapper = this.selectCriteria;
        ElementCollectionMapping elementCollectionMapping = this;
        synchronized (elementCollectionMapping) {
            if (this.selectCriteria == null) {
                MetamodelImpl metamodel = this.getRoot().getType().getMetamodel();
                CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
                Object q = cb.createQuery((Class)this.attribute.getBindableJavaType());
                ((AbstractCriteriaQueryImpl)q).internal();
                EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
                Root r = ((AbstractCriteriaQueryImpl)q).from(type);
                r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
                Join join = r.join(this.attribute.getName());
                join.alias(BatooUtils.acronym(this.attribute.getName()));
                q = ((CriteriaQueryImpl)q).select((Selection)join);
                if (type.hasSingleIdAttribute()) {
                    SingularMapping idMapping = type.getIdMapping();
                    ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                    Path path = r.get(idMapping.getAttribute().getName());
                    Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                    this.selectCriteria = new FinalWrapper<AbstractQuery>(((CriteriaQueryImpl)q).where((Expression)predicate));
                } else {
                    ArrayList predicates = Lists.newArrayList();
                    for (Pair pair : type.getIdMappings()) {
                        BasicMapping idMapping = pair.getFirst();
                        ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                        Path path = r.get(idMapping.getAttribute().getName());
                        Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                        predicates.add(predicate);
                    }
                    this.selectCriteria = new FinalWrapper<AbstractQuery>(((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()])));
                }
            }
            wrapper = this.selectCriteria;
        }
        return (CriteriaQueryImpl)wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<Object[]> getSelectMapCriteria() {
        FinalWrapper<CriteriaQueryImpl<Object[]>> wrapper = this.selectMapCriteria;
        ElementCollectionMapping elementCollectionMapping = this;
        synchronized (elementCollectionMapping) {
            if (this.selectCriteria == null) {
                MetamodelImpl metamodel = this.getRoot().getType().getMetamodel();
                CriteriaBuilderImpl cb = metamodel.getEntityManagerFactory().getCriteriaBuilder();
                CriteriaQuery q = cb.createQuery(Object[].class);
                q.internal();
                EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
                Root r = q.from(type);
                r.alias(BatooUtils.acronym(type.getName()).toLowerCase());
                MapJoinImpl join = (MapJoinImpl)r.join(this.attribute.getName());
                join.alias(BatooUtils.acronym(this.attribute.getName()));
                q = q.multiselect(new Selection[]{join.key(), join.value()});
                if (type.hasSingleIdAttribute()) {
                    SingularMapping idMapping = type.getIdMapping();
                    ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                    Path path = r.get(idMapping.getAttribute().getName());
                    Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                    this.selectMapCriteria = new FinalWrapper<AbstractQuery>(q.where((Expression)predicate));
                } else {
                    ArrayList predicates = Lists.newArrayList();
                    for (Pair pair : type.getIdMappings()) {
                        BasicMapping idMapping = pair.getFirst();
                        ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                        Path path = r.get(idMapping.getAttribute().getName());
                        Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                        predicates.add(predicate);
                    }
                    this.selectMapCriteria = new FinalWrapper<AbstractQuery>(q.where(predicates.toArray(new PredicateImpl[predicates.size()])));
                }
            }
            wrapper = this.selectMapCriteria;
        }
        return (CriteriaQueryImpl)wrapper.value;
    }

    @Override
    public JoinableTable getTable() {
        return this.collectionTable;
    }

    @Override
    public TypeImpl<E> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false));
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public boolean isEager() {
        return this.eager;
    }

    @Override
    public boolean isJoined() {
        return true;
    }

    @Override
    public boolean isMap() {
        return this.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        return this.collectionTable.getKey().createSourceJoin(joinType, parentAlias, alias);
    }

    public void link() {
        String name;
        this.type = this.attribute.getElementType();
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            this.rootMapping = new ElementMapping(this, (EmbeddableTypeImpl)this.type);
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            MapAttributeImpl mapAttribute = (MapAttributeImpl)this.attribute;
            if (this.mapKey != null) {
                if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                    this.keyMapping = (SingularMapping)((Object)this.rootMapping.getMapping(this.mapKey));
                }
                if (this.keyMapping == null) {
                    throw new MappingException("Cannot locate the MapKey: " + this.mapKey, this.attribute.getLocator());
                }
            } else {
                name = this.mapKeyColumn != null && StringUtils.isNotBlank((String)this.mapKeyColumn.getName()) ? this.mapKeyColumn.getName() : this.attribute.getName() + "_KEY";
                this.collectionTable.setKeyColumn(this.mapKeyColumn, name, this.mapKeyTemporalType, this.mapKeyEnumType, mapAttribute.getKeyJavaType());
            }
        }
        String defaultName = this.getAttribute().getName();
        if (this.type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            this.collectionTable.link((EmbeddableTypeImpl)this.type, defaultName, this.rootMapping);
        } else {
            this.collectionTable.link(this, this.type, defaultName, this.column, this.enumType, this.temporalType, this.lob);
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST && this.orderColumn != null) {
            name = StringUtils.isNotBlank((String)this.orderColumn.getName()) ? this.orderColumn.getName() : this.attribute.getName() + "_ORDER";
            this.collectionTable.setOrderColumn(this.orderColumn, name);
        }
    }

    @Override
    public void load(ManagedInstance<?> instance) {
        this.setCollection(instance, this.loadCollection(instance));
    }

    @Override
    public Collection<? extends E> loadCollection(ManagedInstance<?> instance) {
        EntityManagerImpl em = instance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectCriteria());
        EntityTypeImpl<?> rootType = instance.getType();
        Object id = instance.getId().getId();
        if (rootType.hasSingleIdAttribute()) {
            q.setParameter(0, id);
        } else {
            int i = 0;
            for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : rootType.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        return q.getResultList();
    }

    @Override
    public <K> Map<? extends K, ? extends E> loadMap(ManagedInstance<?> instance) {
        EntityManagerImpl em = instance.getSession().getEntityManager();
        TypedQuery q = em.createQuery(this.getSelectMapCriteria());
        EntityTypeImpl<?> rootType = instance.getType();
        Object id = instance.getId().getId();
        if (rootType.hasSingleIdAttribute()) {
            q.setParameter(0, id);
        } else {
            int i = 0;
            for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : rootType.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        HashMap resultMap = Maps.newHashMap();
        for (Object[] pair : q.getResultList()) {
            resultMap.put(pair[0], pair[1]);
        }
        return resultMap;
    }

    @Override
    public void setCollection(ManagedInstance<?> instance, Collection<? extends E> children) {
        ManagedCollection collection = (ManagedCollection)this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false);
        BatooUtils.addAll(children, collection.getDelegate());
        this.set(instance.getInstance(), collection);
    }

    @Override
    public void setLazy(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, true));
    }

    @Override
    public void sortList(Object instance) {
        ManagedList list = (ManagedList)this.get(instance);
        if (list.isInitialized()) {
            Collections.sort(list.getDelegate(), this.getComparator());
        }
    }
}

