/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.persistence.criteria.JoinType;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.JoinableTable;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.RootMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class EmbeddedMapping<Z, X>
extends ParentMapping<Z, X>
implements SingularMapping<Z, X>,
JoinedMapping<Z, X, X> {
    private final EmbeddableTypeImpl<X> embeddable;
    private final EmbeddedAttribute<? super Z, X> attribute;
    private Mapping<? super X, ?, ?>[] singularMappings;

    public EmbeddedMapping(ParentMapping<?, Z> parent, EmbeddedAttribute<? super Z, X> attribute) {
        super(parent, attribute, attribute.getBindableJavaType(), attribute.getName());
        this.attribute = attribute;
        this.embeddable = attribute.getType();
    }

    @Override
    public Object extractKey(Object value) {
        return null;
    }

    @Override
    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        Object value = this.get(instance);
        if (value == null) {
            value = ((EmbeddedAttribute)this.getAttribute()).newInstance();
            this.getAttribute().set(instance, value);
        }
        for (Mapping mapping : this.getChildren()) {
            if (mapping instanceof EmbeddedMapping) {
                ((EmbeddedMapping)mapping).fillValue(type, managedInstance, value);
                continue;
            }
            if (mapping instanceof BasicMapping) {
                ((BasicAttribute)((BasicMapping)mapping).getAttribute()).fillValue(type, managedInstance, value);
                continue;
            }
            throw new MappingException("Embbeded ids can only have basic and embedded attributes.", this.getType().getLocator());
        }
        return true;
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
    }

    public AssociationMetadata getAssociationOverride(String path) {
        AssociationMetadata metadata = null;
        if (this.getParent() instanceof EmbeddedMapping) {
            metadata = ((EmbeddedMapping)this.getParent()).getAssociationOverride(this.getAttribute().getName() + "." + path);
        }
        if (metadata != null) {
            return metadata;
        }
        return ((EmbeddedAttribute)this.getAttribute()).getAssociationOverride(path);
    }

    @Override
    public EmbeddedAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    public ColumnMetadata getAttributeOverride(String path) {
        ColumnMetadata metadata = null;
        if (this.getParent() instanceof EmbeddedMapping) {
            metadata = ((EmbeddedMapping)this.getParent()).getAttributeOverride(this.getAttribute().getName() + "." + path);
        }
        if (metadata != null) {
            return metadata;
        }
        return ((EmbeddedAttribute)this.getAttribute()).getAttributeOverride(path);
    }

    @Override
    public JoinedMapping.MappingType getMappingType() {
        return JoinedMapping.MappingType.EMBEDDABLE;
    }

    @Override
    public RootMapping<?> getRoot() {
        return this.getParent().getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapping<? super X, ?, ?>[] getSingularMappings() {
        if (this.singularMappings != null) {
            return this.singularMappings;
        }
        EmbeddedMapping embeddedMapping = this;
        synchronized (embeddedMapping) {
            if (this.singularMappings != null) {
                return this.singularMappings;
            }
            ArrayList singularMappings = Lists.newArrayList();
            for (Mapping mapping : this.getChildren()) {
                AttributeImpl attribute = mapping.getAttribute();
                switch (attribute.getPersistentAttributeType()) {
                    case BASIC: 
                    case EMBEDDED: {
                        singularMappings.add(mapping);
                        break;
                    }
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: {
                        SingularAssociationMapping association = (SingularAssociationMapping)mapping;
                        if (!association.isOwner() || association.getTable() != null) break;
                        singularMappings.add(mapping);
                    }
                }
            }
            Collections.sort(singularMappings, new Comparator<Mapping<? super X, ?, ?>>(){

                @Override
                public int compare(Mapping<? super X, ?, ?> o1, Mapping<? super X, ?, ?> o2) {
                    return o1.getAttribute().getAttributeId().compareTo(o2.getAttribute().getAttributeId());
                }
            });
            this.singularMappings = singularMappings.toArray(new Mapping[singularMappings.size()]);
            return this.singularMappings;
        }
    }

    @Override
    public JoinableTable getTable() {
        return null;
    }

    @Override
    public EmbeddableTypeImpl<X> getType() {
        return this.embeddable;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean isId() {
        return this.attribute.isId();
    }

    @Override
    public boolean isJoined() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        return null;
    }
}

