/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.jpa.core.impl.cache.CacheInstance;
import org.batoo.jpa.core.impl.collections.ManagedCollection;
import org.batoo.jpa.core.impl.collections.ManagedList;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.jdbc.ForeignKey;
import org.batoo.jpa.core.impl.jdbc.JoinTable;
import org.batoo.jpa.core.impl.jdbc.Joinable;
import org.batoo.jpa.core.impl.jdbc.OrderColumn;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AssociationMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.ListComparator;
import org.batoo.jpa.core.impl.model.mapping.Mapping;
import org.batoo.jpa.core.impl.model.mapping.ParentMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularMapping;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.type.TypeImpl;
import org.batoo.jpa.core.util.Pair;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.AbstractLocator;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.PluralAttributeMetadata;
import org.batoo.jpa.util.BatooUtils;
import org.batoo.jpa.util.FinalWrapper;

public class PluralAssociationMapping<Z, C, E>
extends AssociationMapping<Z, C, E>
implements PluralMapping<Z, C, E> {
    private final PluralAttributeImpl<? super Z, C, E> attribute;
    private final JoinTable joinTable;
    private final ForeignKey foreignKey;
    private EntityTypeImpl<E> type;
    private AssociationMapping<?, ?, ?> inverse;
    private SingularMapping<? super E, ?> mapKeyMapping;
    private Pair<BasicMapping<? super E, ?>, BasicAttribute<?, ?>>[] mapKeyMappings;
    private EmbeddableTypeImpl<?> keyClass;
    private String orderBy;
    private FinalWrapper<Comparator<E>> comparator;
    private ColumnMetadata orderColumn;
    private final String mapKey;
    private ColumnMetadata mapKeyColumn;
    private TemporalType mapKeyTemporalType;
    private EnumType mapKeyEnumType;

    public PluralAssociationMapping(ParentMapping<?, Z> parent, PluralAttributeImpl<? super Z, C, E> attribute) {
        super(parent, (AssociationAttributeMetadata)attribute.getMetadata(), attribute);
        this.attribute = attribute;
        AssociationMetadata metadata = this.getAssociationMetadata();
        if (this.isOwner()) {
            if (this.attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY || metadata.getJoinColumns().size() == 0) {
                this.joinTable = new JoinTable((EntityTypeImpl)this.getRoot().getType(), metadata.getJoinTable());
                this.foreignKey = null;
            } else {
                this.foreignKey = new ForeignKey(this.getAttribute().getMetamodel().getJdbcAdaptor(), metadata.getJoinColumns(), true);
                this.joinTable = null;
            }
        } else {
            this.joinTable = null;
            this.foreignKey = null;
        }
        PluralAttributeMetadata pluralAttributeMetadata = (PluralAttributeMetadata)((Object)attribute.getMetadata());
        if (attribute.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            this.orderBy = pluralAttributeMetadata.getOrderBy();
            this.orderColumn = pluralAttributeMetadata.getOrderColumn();
        } else {
            this.orderBy = null;
            this.orderColumn = null;
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            this.mapKeyColumn = pluralAttributeMetadata.getMapKeyColumn();
            this.mapKeyTemporalType = pluralAttributeMetadata.getMapKeyTemporalType();
            this.mapKeyEnumType = pluralAttributeMetadata.getMapKeyEnumType();
            this.mapKey = pluralAttributeMetadata.getMapKey();
        } else {
            this.mapKeyColumn = null;
            this.mapKeyTemporalType = null;
            this.mapKeyEnumType = null;
            this.mapKey = null;
        }
    }

    @Override
    public void attach(Connection connection, ManagedInstance<?> instance, Joinable[] batch, int batchSize) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performInsert(connection, instance.getInstance(), batch, batchSize);
        } else if (this.foreignKey != null) {
            this.foreignKey.performAttachChild(connection, instance, batch, batchSize);
        }
    }

    @Override
    public void checkTransient(ManagedInstance<?> managedInstance) {
        block4: {
            SessionImpl session;
            Object values;
            block5: {
                block3: {
                    values = this.get(managedInstance.getInstance());
                    session = managedInstance.getSession();
                    if (!(values instanceof List)) break block3;
                    List list = (List)values;
                    for (int i = 0; i < list.size(); ++i) {
                        session.checkTransient(list.get(i));
                    }
                    break block4;
                }
                if (!(values instanceof Collection)) break block5;
                for (Object entity : ((Collection)values).toArray()) {
                    session.checkTransient(entity);
                }
                break block4;
            }
            if (!(values instanceof Map)) break block4;
            for (Object entity : ((Map)values).values()) {
                session.checkTransient(entity);
            }
        }
    }

    @Override
    public void detach(Connection connection, ManagedInstance<?> instance, Object key, Object child) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performRemove(connection, instance.getInstance(), key, child);
        } else if (this.foreignKey != null) {
            this.foreignKey.performDetachChild(connection, key, child);
        }
    }

    @Override
    public void detachAll(Connection connection, ManagedInstance<?> instance) throws SQLException {
        if (this.joinTable != null) {
            this.joinTable.performRemoveAll(connection, instance.getInstance());
        } else if (this.foreignKey != null) {
            this.foreignKey.performDetachAll(connection, instance);
        }
    }

    @Override
    public void enhance(ManagedInstance<?> instance) {
        Object c = this.get(instance.getInstance());
        if (c == null) {
            this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false));
        } else {
            this.set(instance.getInstance(), this.attribute.newCollection(this, instance, c));
        }
    }

    @Override
    public Object extractKey(Object value) {
        Object key = null;
        if (this.mapKeyMapping != null) {
            return this.mapKeyMapping.get(value);
        }
        key = this.keyClass.newInstance();
        for (Pair<BasicMapping<E, ?>, BasicAttribute<?, ?>> pair : this.mapKeyMappings) {
            pair.getSecond().set(key, pair.getFirst().get(value));
        }
        return key;
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
        Object collection = this.get(managedInstance.getInstance());
        if (collection != null) {
            ((ManagedCollection)collection).flush(connection, removals, force);
        }
    }

    public PluralAttributeImpl<? super Z, C, E> getAttribute() {
        return this.attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<E> getComparator() {
        FinalWrapper<Comparator<E>> wrapper = this.comparator;
        if (wrapper == null) {
            PluralAssociationMapping pluralAssociationMapping = this;
            synchronized (pluralAssociationMapping) {
                if (this.comparator == null) {
                    this.comparator = new FinalWrapper(new ListComparator(this));
                }
                wrapper = this.comparator;
            }
        }
        return (Comparator)wrapper.value;
    }

    @Override
    public ForeignKey getForeignKey() {
        return this.foreignKey;
    }

    @Override
    public AssociationMapping<?, ?, ?> getInverse() {
        return this.inverse;
    }

    @Override
    public TypeImpl<?> getMapKeyClass() {
        return this.keyClass;
    }

    public SingularMapping<? super E, ?> getMapKeyIdMapping() {
        return this.mapKeyMapping;
    }

    public Pair<BasicMapping<? super E, ?>, BasicAttribute<?, ?>>[] getMapKeyIdMappings() {
        return this.mapKeyMappings;
    }

    @Override
    public Mapping<?, ?, ?> getMapping(String path) {
        return this.type.getRootMapping().getMapping(path);
    }

    @Override
    public JoinedMapping.MappingType getMappingType() {
        return JoinedMapping.MappingType.PLURAL_ASSOCIATION;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OrderColumn getOrderColumn() {
        if (this.joinTable != null) {
            return this.joinTable.getOrderColumn();
        }
        if (this.foreignKey != null) {
            return this.foreignKey.getOrderColumn();
        }
        return null;
    }

    @Override
    public JoinTable getTable() {
        return this.joinTable;
    }

    @Override
    public EntityTypeImpl<E> getType() {
        return this.type;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false));
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    @Override
    public boolean isJoined() {
        return this.joinTable != null || this.foreignKey != null;
    }

    @Override
    public boolean isMap() {
        return this.getAttribute().getCollectionType() == PluralAttribute.CollectionType.MAP;
    }

    @Override
    public void link() throws MappingException {
        EntityTypeImpl entity = (EntityTypeImpl)this.getRoot().getType();
        this.type = (EntityTypeImpl)this.attribute.getElementType();
        if (!this.isOwner()) {
            this.inverse = (AssociationMapping)this.type.getRootMapping().getMapping(this.getMappedBy());
            if (this.inverse == null) {
                throw new MappingException("Cannot find the mappedBy attribute " + this.getMappedBy() + " specified on " + this.attribute.getJavaMember(), new AbstractLocator[0]);
            }
            this.inverse.setInverse(this);
        } else {
            String name;
            if (this.joinTable != null) {
                this.joinTable.link(entity, this.type);
                if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.LIST && this.orderColumn != null) {
                    name = StringUtils.isNotBlank((String)this.orderColumn.getName()) ? this.orderColumn.getName() : this.attribute.getName() + "_ORDER";
                    this.joinTable.setOrderColumn(this.orderColumn, name);
                }
            }
            if (this.foreignKey != null) {
                this.foreignKey.link(null, (EntityTypeImpl)this.getRoot().getType());
                this.foreignKey.setTable(this.type.getPrimaryTable());
                if (this.orderColumn != null) {
                    name = StringUtils.isNotBlank((String)this.orderColumn.getName()) ? this.orderColumn.getName() : this.attribute.getName() + "_ORDER";
                    this.foreignKey.setOrderColumn(this.orderColumn, name);
                }
            }
        }
        if (this.attribute.getCollectionType() == PluralAttribute.CollectionType.MAP) {
            if (this.mapKeyColumn != null) {
                MapAttributeImpl mapAttribute = (MapAttributeImpl)this.attribute;
                String name = StringUtils.isNotBlank((String)this.mapKeyColumn.getName()) ? this.mapKeyColumn.getName() : this.attribute.getName() + "_KEY";
                this.joinTable.setKeyColumn(this.mapKeyColumn, name, this.mapKeyTemporalType, this.mapKeyEnumType, mapAttribute.getKeyJavaType());
            } else if (StringUtils.isBlank((String)this.mapKey)) {
                if (this.type.hasSingleIdAttribute()) {
                    this.mapKeyMapping = this.type.getIdMapping();
                } else {
                    this.mapKeyMappings = this.type.getIdMappings();
                    this.keyClass = (EmbeddableTypeImpl)this.type.getIdType();
                }
            } else {
                this.mapKeyMapping = (SingularMapping)((Object)this.type.getRootMapping().getMapping(this.mapKey));
                if (this.mapKeyMapping == null) {
                    throw new MappingException("Cannot locate the MapKey: " + this.mapKey, this.attribute.getLocator());
                }
            }
        }
    }

    @Override
    public void load(ManagedInstance<?> instance) {
        this.setCollection(instance, this.loadCollection(instance));
    }

    @Override
    public Collection<? extends E> loadCollection(ManagedInstance<?> managedInstance) {
        CacheInstance cacheInstance;
        Collection<?> collection;
        EntityManagerImpl em = managedInstance.getSession().getEntityManager();
        List<Object> children = null;
        if (this.type.isCachable() && (collection = (cacheInstance = em.getEntityManagerFactory().getCache().get(managedInstance.getId())).getCollection(managedInstance, this)) != null) {
            children = Lists.newArrayList();
            BatooUtils.addAll(collection, children);
        }
        if (children == null) {
            TypedQuery q = em.createQuery(this.getSelectCriteria());
            EntityTypeImpl<?> rootType = managedInstance.getType();
            Object id = managedInstance.getId().getId();
            if (rootType.hasSingleIdAttribute()) {
                q.setParameter(0, id);
            } else {
                int i = 0;
                for (Pair<BasicMapping<?, ?>, BasicAttribute<?, ?>> pair : rootType.getIdMappings()) {
                    q.setParameter(i++, pair.getSecond().get(id));
                }
            }
            children = q.getResultList();
            if (this.type.isCachable()) {
                // empty if block
            }
        }
        Object instance = managedInstance.getInstance();
        if (this.getInverse() != null && ((PluralAttributeImpl)this.getAttribute()).getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY) {
            Object[] childrenToProcess;
            for (Object child : childrenToProcess = children.toArray(new Object[children.size()])) {
                Object newParent = this.getInverse().get(child);
                if (newParent != null && newParent != managedInstance.getInstance()) {
                    children.remove(child);
                    continue;
                }
                this.getInverse().set(child, instance);
            }
        }
        return children;
    }

    @Override
    public <K> Map<? extends K, ? extends E> loadMap(ManagedInstance<?> instance) {
        return null;
    }

    @Override
    public void mergeWith(EntityManagerImpl entityManager, ManagedInstance<?> instance, Object entity, MutableBoolean requiresFlush, IdentityHashMap<Object, Object> processed) {
        ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
        if (collection != null && collection.isInitialized()) {
            collection.mergeWith(entityManager, entity, requiresFlush, processed);
        }
    }

    public void persistAdditions(EntityManagerImpl entityManager, ManagedInstance<?> instance) {
        if (this.cascadesPersist()) {
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.persistAdditions(entityManager);
        }
    }

    @Override
    public boolean references(Object instance, Object reference) {
        Object values = this.get(instance);
        if (values == null) {
            return false;
        }
        if (values instanceof Collection) {
            return ((Collection)values).contains(reference);
        }
        return ((Map)values).containsValue(reference);
    }

    @Override
    public void refresh(ManagedInstance<?> instance, Set<Object> processed) {
        if (this.isEager()) {
            this.initialize(instance);
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.refreshChildren();
            if (this.cascadesRefresh()) {
                EntityManagerImpl entityManager = instance.getSession().getEntityManager();
                if (collection.getDelegate() instanceof List) {
                    List list = (List)collection.getDelegate();
                    for (int i = 0; i < list.size(); ++i) {
                        entityManager.refreshImpl(list.get(i), null, processed);
                    }
                } else {
                    for (Object child : collection.getDelegate()) {
                        entityManager.refreshImpl(child, null, processed);
                    }
                }
            }
            if (this.orderBy != null) {
                this.sortList(instance);
            }
        } else {
            this.setLazy(instance);
        }
    }

    public void removeOrphans(EntityManagerImpl entityManager, ManagedInstance<?> instance) {
        if (this.removesOrphans()) {
            ManagedCollection collection = (ManagedCollection)this.get(instance.getInstance());
            collection.removeOrphans(entityManager);
        }
    }

    @Override
    public void setCollection(ManagedInstance<?> instance, Collection<? extends E> children) {
        ManagedCollection collection = (ManagedCollection)this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, false);
        BatooUtils.addAll(children, collection.getDelegate());
        this.set(instance.getInstance(), collection);
    }

    @Override
    public void setInverse(AssociationMapping<?, ?, ?> inverse) {
        this.inverse = inverse;
    }

    @Override
    public void setLazy(ManagedInstance<?> instance) {
        this.set(instance.getInstance(), this.attribute.newCollection((PluralMapping<?, C, E>)this, instance, true));
    }

    @Override
    public void sortList(Object instance) {
        ManagedList list = (ManagedList)this.get(instance);
        if (list.isInitialized()) {
            Collections.sort(list.getDelegate(), this.getComparator());
        }
    }
}

