/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.type;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.manager.CallbackAvailability;
import org.batoo.jpa.core.impl.manager.CallbackManager;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.VersionType;
import org.batoo.jpa.core.impl.model.type.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.type.ManagedTypeImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.attribute.AttributesMetadata;
import org.batoo.jpa.parser.metadata.attribute.EmbeddedIdAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.IdAttributeMetadata;
import org.batoo.jpa.parser.metadata.attribute.VersionAttributeMetadata;
import org.batoo.jpa.parser.metadata.type.IdentifiableTypeMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;

public abstract class IdentifiableTypeImpl<X>
extends ManagedTypeImpl<X>
implements IdentifiableType<X> {
    private final IdentifiableTypeImpl<? super X> supertype;
    private final EmbeddableTypeImpl<?> idType;
    private final Map<String, SingularAttributeImpl<X, ?>> declaredIdAttributes = Maps.newHashMap();
    private final Map<String, SingularAttributeImpl<? super X, ?>> idAttributes = Maps.newHashMap();
    private EmbeddedAttribute<X, ?> declaredEmbeddedId;
    private EmbeddedAttribute<? super X, ?> embeddedId;
    private BasicAttribute<X, ?> declaredVersionAttribute;
    private BasicAttribute<? super X, ?> versionAttribute;
    private VersionType versionType;
    private final CallbackManager callbackManager;
    private CallbackAvailability callbackAvailability;

    public IdentifiableTypeImpl(MetamodelImpl metamodel, IdentifiableTypeImpl<? super X> supertype, Class<X> javaType, IdentifiableTypeMetadata metadata) {
        super(metamodel, javaType, metadata);
        this.supertype = supertype;
        this.idType = this.getIdClass(metadata);
        this.addIdAttributes(metadata);
        this.callbackManager = new CallbackManager(metadata, this.getJavaType());
    }

    @Override
    protected void addAttribute(AttributeImpl<? super X, ?> attribute) {
        EmbeddedAttribute embeddedAttribute;
        if (attribute instanceof BasicAttribute) {
            BasicAttribute basicAttribute = (BasicAttribute)attribute;
            if (basicAttribute.isId()) {
                if (attribute.getDeclaringType() == this) {
                    this.declaredIdAttributes.put(attribute.getName(), basicAttribute);
                }
                if (this.embeddedId != null) {
                    throw new MappingException("Embbeded id attributes cannot be combined with other id attributes.", attribute.getLocator(), this.embeddedId.getLocator());
                }
                if (this.idType == null && this.idAttributes.size() > 1) {
                    throw new MappingException("Multiple id attributes are only allowed with id class declaration.", attribute.getLocator(), this.idAttributes.values().iterator().next().getLocator());
                }
                this.idAttributes.put(attribute.getName(), basicAttribute);
            }
            if (basicAttribute.isVersion()) {
                if (this.versionAttribute != null) {
                    throw new MappingException("Multiple version attributes not supported.", this.versionAttribute.getLocator(), attribute.getLocator());
                }
                if (attribute.getDeclaringType() == this) {
                    this.declaredVersionAttribute = basicAttribute;
                }
                this.versionAttribute = basicAttribute;
                this.versionType = VersionType.versionType(this.versionAttribute.getJavaType());
            }
        } else if (attribute instanceof EmbeddedAttribute && (embeddedAttribute = (EmbeddedAttribute)attribute).isId()) {
            if (this.idType != null) {
                throw new MappingException("When IdClass defined, it is illegal to use embedded id attributes.", this.getLocator());
            }
            if (this.idAttributes.size() > 0) {
                throw new MappingException("Embbeded id attributes cannot be combined with other id attributes.", attribute.getLocator(), this.idAttributes.values().iterator().next().getLocator());
            }
            if (embeddedAttribute.getDeclaringType() == this) {
                this.declaredEmbeddedId = embeddedAttribute;
            }
            this.idAttributes.put(attribute.getName(), (SingularAttributeImpl)attribute);
            this.embeddedId = embeddedAttribute;
        }
        super.addAttribute(attribute);
    }

    @Override
    protected void addAttributes(ManagedTypeMetadata entityMetadata) {
        if (this.supertype != null) {
            for (Attribute attribute : this.supertype.getAttributes()) {
                this.addAttribute((AttributeImpl)attribute);
            }
            if (this.supertype.versionAttribute != null) {
                this.addAttribute(this.supertype.versionAttribute);
            }
        }
        super.addAttributes(entityMetadata);
    }

    private void addIdAttributes(ManagedTypeMetadata metadata) {
        AttributesMetadata attributes = metadata.getAttributes();
        for (EmbeddedIdAttributeMetadata embeddedIdAttributeMetadata : attributes.getEmbeddedIds()) {
            this.addAttribute(new EmbeddedAttribute(this, embeddedIdAttributeMetadata));
        }
        for (IdAttributeMetadata idAttributeMetadata : attributes.getIds()) {
            this.addAttribute(new BasicAttribute(this, idAttributeMetadata));
        }
        for (VersionAttributeMetadata versionAttributeMetadata : attributes.getVersions()) {
            this.declaredVersionAttribute = new BasicAttribute(this, versionAttributeMetadata);
            this.addAttribute(this.declaredVersionAttribute);
        }
    }

    public void fireCallbacks(boolean self, Object instance, EntityListenerMetadata.EntityListenerType type) {
        if (!this.callbackManager.excludeDefaultListeners() && self) {
            this.getMetamodel().fireCallbacks(instance, type);
        }
        if (this.getSupertype() != null && !this.callbackManager.excludeSuperclassListeners()) {
            this.getSupertype().fireCallbacks(false, instance, type);
        }
        this.callbackManager.fireCallbacks(instance, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallbackAvailability getAvailability() {
        if (this.callbackAvailability != null) {
            return this.callbackAvailability;
        }
        IdentifiableTypeImpl identifiableTypeImpl = this;
        synchronized (identifiableTypeImpl) {
            if (this.callbackAvailability != null) {
                return this.callbackAvailability;
            }
            this.callbackAvailability = this.callbackManager.getAvailibility(this.getMetamodel(), (IdentifiableTypeImpl<?>)this.getSupertype());
            return this.callbackAvailability;
        }
    }

    protected CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> type) {
        if (this.declaredEmbeddedId != null && type == this.declaredEmbeddedId.getJavaType()) {
            return this.declaredEmbeddedId;
        }
        if (this.idType != null) {
            throw new IllegalArgumentException("Type defines multiple id attributes");
        }
        if (this.declaredIdAttributes.size() > 1) {
            return this.declaredIdAttributes.values().iterator().next();
        }
        return null;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> type) {
        return this.versionAttribute;
    }

    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> type) {
        if (this.embeddedId != null && type == this.embeddedId.getJavaType()) {
            return this.embeddedId;
        }
        if (this.idType != null) {
            throw new IllegalArgumentException("Type defines multiple id attributes");
        }
        if (this.idAttributes.size() > 1) {
            return this.idAttributes.values().iterator().next();
        }
        SingularAttributeImpl<X, ?> attribute = this.idAttributes.values().iterator().next();
        return attribute.getJavaType() == type ? attribute : null;
    }

    private EmbeddableTypeImpl<?> getIdClass(IdentifiableTypeMetadata metadata) {
        if (StringUtils.isNotBlank((String)metadata.getIdClass())) {
            try {
                Class<?> clazz = this.getMetamodel().getEntityManagerFactory().getClassloader().loadClass(metadata.getIdClass());
                return this.getMetamodel().idClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (this.idType != null) {
            HashSet idAttributes = Sets.newHashSet();
            idAttributes.addAll(this.idAttributes.values());
            return idAttributes;
        }
        throw new IllegalArgumentException("Type does not have an id class definition");
    }

    public Type<?> getIdType() {
        if (this.idType != null) {
            return this.idType;
        }
        if (this.embeddedId != null) {
            return this.embeddedId.getType();
        }
        return this.idAttributes.values().iterator().next().getType();
    }

    public IdentifiableTypeImpl<? super X> getSupertype() {
        return this.supertype;
    }

    public <Y> BasicAttribute<? super X, Y> getVersion(Class<Y> type) {
        if (this.versionAttribute == null) {
            return null;
        }
        if (this.versionAttribute.getJavaType() != type) {
            throw new IllegalArgumentException("Version does not match specified type : " + type.getName());
        }
        return this.versionAttribute;
    }

    public BasicAttribute<? super X, ?> getVersionAttribute() {
        return this.versionAttribute;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public boolean hasSingleIdAttribute() {
        return this.idAttributes.size() == 1;
    }

    public boolean hasVersionAttribute() {
        return this.versionAttribute != null;
    }

    public void updateAvailability(CallbackAvailability availability, Boolean forUpdates) {
        availability.updateAvailability(this.getAvailability(), forUpdates);
    }
}

