/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import org.batoo.jpa.parser.impl.AbstractLocator;

public class MappingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private static String getLocation(AbstractLocator[] locators) {
        if (locators == null) {
            return "";
        }
        Collection filteredLocators = Collections2.filter(Arrays.asList(locators), (Predicate)Predicates.not((Predicate)Predicates.isNull()));
        if (filteredLocators.size() == 0) {
            return "";
        }
        return " Defined at:" + (filteredLocators.size() > 1 ? "\n\t" : " ") + Joiner.on((String)"\n\t").skipNulls().join((Iterable)filteredLocators);
    }

    public MappingException(String message, AbstractLocator ... locators) {
        super(message + MappingException.getLocation(locators));
    }

    public MappingException(String message, Throwable cause, AbstractLocator ... locators) {
        super(message + MappingException.getLocation(locators), cause);
    }
}

