/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.batoo.jpa.common.BatooException;
import org.batoo.jpa.common.log.BLogger;
import org.batoo.jpa.common.log.BLoggerFactory;
import org.batoo.jpa.parser.PersistenceParser;
import org.batoo.jpa.parser.impl.OrmParser;
import org.batoo.jpa.parser.impl.metadata.MetadataImpl;
import org.batoo.jpa.parser.persistence.Persistence;
import org.batoo.jpa.parser.persistence.PersistenceUnitCachingType;
import org.batoo.jpa.parser.persistence.PersistenceUnitValidationModeType;

public class PersistenceParserImpl
implements PersistenceParser {
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String ORM_XML = "META-INF/orm.xml";
    private static final BLogger LOG = BLoggerFactory.getLogger(PersistenceParserImpl.class);
    private final String puName;
    private final String provider;
    private final ClassLoader classloader;
    private final MetadataImpl metadata;
    private final Map<String, Object> properties = Maps.newHashMap();
    private final List<String> ormMappingFiles;
    private final boolean hasValidators;
    private final SharedCacheMode sharedCacheMode;
    private final DataSource jtaDataSource;
    private final DataSource nonJtaDataSource;

    public PersistenceParserImpl(PersistenceUnitInfo puInfo, Map<String, Object> properties) {
        this.puName = puInfo.getPersistenceUnitName();
        this.classloader = puInfo.getClassLoader();
        this.provider = null;
        for (Map.Entry<Object, Object> entry : puInfo.getProperties().entrySet()) {
            this.properties.put((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.properties.put((String)entry.getKey(), entry.getValue());
        }
        this.hasValidators = puInfo.getValidationMode() == ValidationMode.AUTO || puInfo.getValidationMode() == ValidationMode.CALLBACK;
        this.metadata = new MetadataImpl();
        this.ormMappingFiles = puInfo.getMappingFileNames();
        this.parseOrmXmls();
        this.metadata.parse(puInfo.getJarFileUrls(), this.classloader, puInfo.getManagedClassNames(), puInfo.excludeUnlistedClasses());
        this.sharedCacheMode = puInfo.getSharedCacheMode();
        this.jtaDataSource = puInfo.getJtaDataSource();
        this.nonJtaDataSource = puInfo.getNonJtaDataSource();
    }

    public PersistenceParserImpl(String puName, Map<String, Object> properties) {
        this.puName = puName;
        this.classloader = Thread.currentThread().getContextClassLoader();
        Persistence.PersistenceUnit puInfo = this.createPersistenceUnit();
        this.provider = puInfo.getProvider();
        for (Persistence.PersistenceUnit.Properties.Property property : puInfo.getProperties().getProperties()) {
            this.properties.put(property.getName(), property.getValue());
        }
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                this.properties.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.hasValidators = puInfo.getValidationMode() == PersistenceUnitValidationModeType.AUTO || puInfo.getValidationMode() == PersistenceUnitValidationModeType.CALLBACK;
        this.metadata = new MetadataImpl(puInfo.getClazzs());
        this.ormMappingFiles = puInfo.getMappingFiles();
        this.parseOrmXmls();
        this.metadata.parse(this.classloader);
        switch (puInfo.getSharedCacheMode() != null ? puInfo.getSharedCacheMode() : PersistenceUnitCachingType.NONE) {
            case ALL: {
                this.sharedCacheMode = SharedCacheMode.ALL;
                break;
            }
            case DISABLE_SELECTIVE: {
                this.sharedCacheMode = SharedCacheMode.DISABLE_SELECTIVE;
                break;
            }
            case ENABLE_SELECTIVE: {
                this.sharedCacheMode = SharedCacheMode.ENABLE_SELECTIVE;
                break;
            }
            case NONE: {
                this.sharedCacheMode = SharedCacheMode.NONE;
                break;
            }
            default: {
                this.sharedCacheMode = SharedCacheMode.NONE;
            }
        }
        this.jtaDataSource = null;
        this.nonJtaDataSource = null;
    }

    private Persistence.PersistenceUnit createPersistenceUnit() {
        try {
            LOG.info("Loading persistence.xml");
            InputStream is = this.classloader.getResourceAsStream(PERSISTENCE_XML);
            if (is == null) {
                throw new BatooException("persistence.xml not found in the classpath");
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Persistence.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Persistence persistence = (Persistence)unmarshaller.unmarshal(is);
            for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnits()) {
                if (!this.puName.equals(persistenceUnit.getName())) continue;
                return persistenceUnit;
            }
        }
        catch (Exception e) {
            throw new BatooException("Unable to parse persistence.xml", e);
        }
        throw new BatooException("Persistence unit " + this.puName + " not found.");
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public DataSource getJtaDatasource() {
        return this.jtaDataSource;
    }

    @Override
    public MetadataImpl getMetadata() {
        return this.metadata;
    }

    @Override
    public DataSource getNonJtaDatasource() {
        return this.nonJtaDataSource;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    @Override
    public boolean hasValidators() {
        return this.hasValidators;
    }

    private void parseOrmXml(String mappingFile) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(mappingFile);
        if (is != null) {
            OrmParser ormParser = new OrmParser(mappingFile);
            ormParser.consume(is);
            this.metadata.merge(ormParser.getMetadata());
            LOG.trace("Merged metamodel {0}", this.metadata);
        }
    }

    private void parseOrmXmls() {
        if (this.ormMappingFiles.size() > 0) {
            for (String mappingFile : this.ormMappingFiles) {
                this.parseOrmXml(mappingFile);
            }
        } else {
            this.parseOrmXml(ORM_XML);
        }
    }
}

