/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.MapsId;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.TemporalType;
import org.batoo.jpa.annotations.FetchJoin;
import org.batoo.jpa.common.reflect.ReflectHelper;
import org.batoo.jpa.parser.impl.metadata.ColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.JoinColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.JoinTableMetadaImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.AttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinTableMetadata;
import org.batoo.jpa.parser.metadata.attribute.AssociationAttributeMetadata;

public class AssociationAttributeMetadataImpl
extends AttributeMetadataImpl
implements AssociationAttributeMetadata {
    private String targetEntity;
    private final Set<CascadeType> cascades;
    private final FetchType fetchType;
    private final int maxFetchDepth;
    private final JoinTableMetadata joinTable;
    private final List<JoinColumnMetadata> joinColumns = Lists.newArrayList();

    public AssociationAttributeMetadataImpl(Member member, AssociationAttributeMetadata metadata) {
        super(member, metadata);
        this.cascades = metadata.getCascades();
        this.fetchType = metadata.getFetchType();
        this.joinTable = metadata.getJoinTable();
        this.maxFetchDepth = metadata.getMaxFetchDepth();
        this.joinColumns.addAll(Lists.newArrayList(metadata.getJoinColumns()));
    }

    public AssociationAttributeMetadataImpl(Member member, String name, Set<Class<? extends Annotation>> parsed, String targetEntity, FetchType fetchType, CascadeType[] cascades) {
        super(member, name);
        this.targetEntity = "void".equals(targetEntity) ? null : targetEntity;
        this.fetchType = fetchType;
        this.cascades = cascades != null ? Sets.newHashSet((Object[])cascades) : Sets.newHashSet();
        JoinColumns joinColumns = ReflectHelper.getAnnotation(member, JoinColumns.class);
        JoinColumn joinColumn = ReflectHelper.getAnnotation(member, JoinColumn.class);
        JoinTable joinTable = ReflectHelper.getAnnotation(member, JoinTable.class);
        FetchJoin fetchJoin = ReflectHelper.getAnnotation(member, FetchJoin.class);
        parsed.add(FetchJoin.class);
        int n = this.maxFetchDepth = fetchJoin != null ? fetchJoin.maxDepth() : 0;
        if (joinColumns != null && joinColumns.value().length > 0) {
            parsed.add(JoinColumns.class);
            for (JoinColumn column : joinColumns.value()) {
                this.joinColumns.add(new JoinColumnMetadataImpl(this.getLocator(), column));
            }
            this.joinTable = null;
        } else if (joinColumn != null) {
            parsed.add(JoinColumn.class);
            this.joinColumns.add(new JoinColumnMetadataImpl(this.getLocator(), joinColumn));
            this.joinTable = null;
        } else if (joinTable != null) {
            parsed.add(JoinTable.class);
            this.joinTable = new JoinTableMetadaImpl(this.getLocator(), joinTable);
        } else {
            this.joinTable = null;
        }
    }

    @Override
    public Set<CascadeType> getCascades() {
        return this.cascades;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public List<JoinColumnMetadata> getJoinColumns() {
        return this.joinColumns;
    }

    @Override
    public JoinTableMetadata getJoinTable() {
        return this.joinTable;
    }

    @Override
    public int getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    protected String handleMapKey(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKey annotation = ReflectHelper.getAnnotation(member, MapKey.class);
        if (annotation != null) {
            parsed.add(MapKey.class);
            return annotation.name();
        }
        return null;
    }

    protected String handleMapKeyClassName(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyClass annotation = ReflectHelper.getAnnotation(member, MapKeyClass.class);
        if (annotation != null) {
            parsed.add(MapKeyClass.class);
            return annotation.value().getName();
        }
        return null;
    }

    protected ColumnMetadata handleMapKeyColumn(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyColumn annotation = ReflectHelper.getAnnotation(member, MapKeyColumn.class);
        if (annotation != null) {
            parsed.add(MapKeyColumn.class);
            return new ColumnMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    protected EnumType handleMapKeyEnumType(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyEnumerated annotation = ReflectHelper.getAnnotation(member, MapKeyEnumerated.class);
        if (annotation != null) {
            parsed.add(MapKeyEnumerated.class);
            return annotation.value();
        }
        return null;
    }

    protected TemporalType handleMapKeyTemporalType(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyTemporal annotation = ReflectHelper.getAnnotation(member, MapKeyTemporal.class);
        if (annotation != null) {
            parsed.add(MapKeyTemporal.class);
            return annotation.value();
        }
        return null;
    }

    protected String handleMapsId(Member member, Set<Class<? extends Annotation>> parsed) {
        MapsId annotation = ReflectHelper.getAnnotation(member, MapsId.class);
        if (annotation != null) {
            parsed.add(MapsId.class);
            return annotation.value();
        }
        return null;
    }

    protected String handleOrderBy(Member member, Set<Class<? extends Annotation>> parsed) {
        OrderBy annotation = ReflectHelper.getAnnotation(member, OrderBy.class);
        if (annotation != null) {
            parsed.add(OrderBy.class);
            return annotation.value();
        }
        return null;
    }

    protected ColumnMetadata handleOrderColumn(Member member, Set<Class<? extends Annotation>> parsed) {
        OrderColumn annotation = ReflectHelper.getAnnotation(member, OrderColumn.class);
        if (annotation != null) {
            parsed.add(OrderColumn.class);
            return new ColumnMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }
}

